<table id="billing-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md">
    <thead>
        <tr class="text-sm leading-normal text-white uppercase bg-black">
            <th class="px-6 py-3">Pay Period Start</th>
            <th class="px-6 py-3">Pay Period End</th>

            <th class="px-6 py-3">Actions</th>
        </tr>
    </thead>
    <tbody class="text-sm font-light text-center text-gray-600">

    </tbody>
</table>




<script>
    $(document).ready(function() {
        var clientId = {{ $company->id }}; // Assuming you have a $client variable available

        var employedTable = $('#billing-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('billing.index', ['id' => ':id']) }}".replace(':id',
                    clientId),
                data: function(d) {

                    d.company_id = clientId;
                }
            },
            columns: [{
                    data: 'pay_period_start',
                    name: 'pay_period_start'
                },
                {
                    data: 'pay_period_end',
                    name: 'pay_period_end'
                },


                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ],
            order: [
                [0, 'desc']
            ]
        });
    });
</script>
