@extends('layouts.sidebar')
@section('title', 'billings')
@section('content')
    <style>
        @media print {
            @page {
                size: A4 landscape;
                margin: 10mm;
            }

            body * {
                visibility: hidden;
            }

            .print-content,
            .print-content * {
                visibility: visible;
                font-size: 10px;
                /* Adjust the font size as needed */
            }

            .print-content {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                height: auto;
                /* Adjusted for landscape height */
                padding: 10mm;
                /* Add padding to simulate margin */
                box-sizing: border-box;
            }

            .print-content table td,
            .print-content table th {
                padding: 2px;
                /* Adjust the padding as needed */
            }
        }
    </style>
    <div class="p-6 mx-auto bg-white rounded-lg shadow-md print-content">


        <div class="mb-20 text-2xl text-center">
            <p class="font-bold">DAVAO MANPOWER INC.</p>
            <p class="text-sm">Corner Ponciano & Rizal Street Davao City</p>
            <p class="text-sm">Tel # 224-56-03 & telefax #224-56-09</p>

        </div>
        <div class="mb-2">
            <p class="text-sm font-bold">Client Name: <span class="font-normal">{{ $client->business_name }}</span></span></p>
            <p class="text-sm font-bold">Address: <span class="font-normal">{{ $client->address }}</span></p>
            <p class="text-sm font-bold">Billing Ref.#: <span class="font-normal"></span></p>
            <p class="text-sm font-bold">Period Covered: <span class="font-normal ">
                    {{ \Carbon\Carbon::parse($payPeriodStart)->format('F d, Y') }} -
                    {{ \Carbon\Carbon::parse($payPeriodEnd)->format('F d, Y') }}</span></p>
        </div>

        <table class="min-w-full table-auto">
            <thead>
                <tr class="text-xs leading-normal text-gray-600 uppercase bg-gray-200">
                    <th class="px-4 py-2 md:py-3 md:px-6 ">Area/Location</th>
                    <th class="px-4 py-2 md:py-3 md:px-6 ">Name</th>
                    <th class="px-4 py-2 md:py-3 md:px-6 ">Minimum Wage</th>
                    <th class="px-4 py-2 md:py-3 md:px-6 ">Days of Duty</th>
                    <th class="px-4 py-2 md:py-3 md:px-6 ">Undertime</th>
                    <th class="px-4 py-2 md:py-3 md:px-6 ">Net No. of Days</th>
                    <th class="px-4 py-2 md:py-3 md:px-6 ">Basic Pay</th>
                    <th class="px-4 py-2 md:py-3 md:px-6 ">Basic COLA</th>
                    <th class="px-4 py-2 md:py-3 md:px-6 ">Transpo Allowance (50 pesos)</th>
                    <th class="px-4 py-2 md:py-3 md:px-6 ">Total Gross</th>
                    <th class="px-4 py-2 md:py-3 md:px-6 ">AFS 6%</th>
                    <th class="px-4 py-2 md:py-3 md:px-6 ">12% VAT</th>
                    <th class="px-4 py-2 md:py-3 md:px-6 ">2% Withholding</th>
                    <th class="px-4 py-2 md:py-3 md:px-6 ">Total Bill</th>
                </tr>
            </thead>
            @php
                $total_gross = '0';
            @endphp
            <tbody class="text-xs font-light text-gray-600">
                @foreach ($data as $data)
                    <tr class="text-center border-t border-gray-300">

                        <td class="px-4 py-2 md:py-3 md:px-6">{{ $data->client->business_name }}</td>
                        <td class="px-4 py-2 md:py-3 md:px-6">{{ $data->employee->last_name }}</td>
                        @foreach ($data->employee->channelclient->where('status', '1') as $channel)
                            <td class="px-4 py-2 md:py-3 md:px-6">{{ $channel->salary }}</td>
                        @endforeach
                        <td class="px-4 py-2 md:py-3 md:px-6">{{ $data->days_worked }}</td>
                        <td class="px-4 py-2 md:py-3 md:px-6">{{ $data->total_undertime_hours }}</td>
                        <td class="px-4 py-2 md:py-3 md:px-6">{{ $data->days_worked }}</td>
                        @foreach ($data->employee->channelclient->where('status', '1') as $channel)
                            <td class="px-4 py-2 md:py-3 md:px-6">{{ $channel->salary }}</td>
                        @endforeach
                        <td class="px-4 py-2 md:py-3 md:px-6"></td>
                        <td class="px-4 py-2 md:py-3 md:px-6">{{ $data->days_worked }}</td>
                        <td class="px-4 py-2 md:py-3 md:px-6">{{ $data->gross_pay }}</td>
                        <td class="px-4 py-2 md:py-3 md:px-6">{{ $data->gross_pay }}</td>
                        <td class="px-4 py-2 md:py-3 md:px-6">{{ $data->gross_pay }}</td>
                        <td class="px-4 py-2 md:py-3 md:px-6">{{ $data->gross_pay }}</td>
                        <td class="px-4 py-2 md:py-3 md:px-6">{{ $data->gross_pay }}</td>
                        <td class="px-4 py-2 md:py-3 md:px-6">{{ $data->gross_pay }}</td>
                        @php
                            $total_gross += $data->gross_pay;
                        @endphp

                    </tr>
                @endforeach
                <!-- Additional rows would go here -->
                <tr class="font-bold bg-gray-200 border-t border-gray-300">
                    <td colspan="9" class="px-4 py-2 text-right md:py-3 md:px-6">Total:</td>
                    <td class="px-4 py-2 md:py-3 md:px-6">{{ $total_gross }}</td>
                    <td class="px-4 py-2 md:py-3 md:px-6">755.12</td>
                    <td class="px-4 py-2 md:py-3 md:px-6">94.50</td>
                    <td class="px-4 py-2 md:py-3 md:px-6">44.00</td>
                    <td class="px-4 py-2 md:py-3 md:px-6">42,857.02</td>
                </tr>
            </tbody>
        </table>



    </div>
    <div class="mt-4 text-center">
        <button onclick="window.print()" class="px-4 py-2 font-bold text-white bg-blue-500 rounded hover:bg-blue-700">
            Print
        </button>
    </div>
@endsection
