<div class="relative w-full ">
    <div id="subscribe-form-modal"
        class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
        <div class="bg-white rounded-lg shadow-lg p-6 w-auto  mt-20">
            <div class="flex flex-col px-5 py-4 bg-white rounded-2xl">
                <div class="flex items-center justify-between pb-4 border-b border-gray-200">
                    <h4 class="text-sm font-medium text-gray-900">Create New Company</h4>
                    <button class="block cursor-pointer close-modal-button" onclick="closeModal('subscribe-form-modal')">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path d="M7.75732 7.75739L16.2426 16.2427M16.2426 7.75739L7.75732 16.2427" stroke="black"
                                stroke-width="1.6" stroke-linecap="round" />
                        </svg>
                    </button>
                </div>
                <div class="">
                    <form action="{{ route('clients.store') }}" method="POST"
                        class="max-w-4xl p-8 mx-auto bg-white rounded-lg shadow-md">
                        @csrf
                        <div id="errorMessages" class="mb-4 text-center text-red-500"></div>

                        <h2 class="mb-6 text-xl font-semibold text-center text-gray-800">Create a New Company</h2>

                        <div class="grid grid-cols-1 gap-8 lg:grid-cols-2">
                            <!-- Agency Selection -->
                            <div>
                                <label for="agency_id" class="block mb-2 text-sm font-medium text-gray-700">Select
                                    Agency</label>
                                <select name="agency_id" id="agency_id"
                                    class="w-full h-12 border border-black rounded-lg shadow-sm focus:ring-black focus:border-black px-4 text-sm @error('agency_id') border-red-500 @enderror"
                                    required>
                                    <option value="">Select Agency</option>
                                    @foreach ($companies as $company)
                                        <option value="{{ $company->id }}">{{ $company->name }}</option>
                                    @endforeach
                                </select>
                                @error('agency_id')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Business Name -->
                            <div>
                                <label for="business_name" class="block mb-2 text-sm font-medium text-gray-700">Business
                                    Name</label>
                                <input type="text" name="business_name" id="business_name"
                                    class="w-full h-12 px-4 text-sm border border-black rounded-lg shadow-sm focus:ring-black focus:border-black"
                                    placeholder="Business name" required>
                            </div>

                            <!-- Address -->
                            <div>
                                <label for="address"
                                    class="block mb-2 text-sm font-medium text-gray-700">Address</label>
                                <input type="text" name="address" id="address"
                                    class="w-full h-12 px-4 text-sm border border-black rounded-lg shadow-sm focus:ring-black focus:border-black"
                                    placeholder="Address" required>
                            </div>

                            <!-- Contact Number -->
                            <div>
                                <label for="contact_number" class="block mb-2 text-sm font-medium text-gray-700">Contact
                                    Number</label>
                                <input type="text" name="contact_number" id="contact_number"
                                    class="w-full h-12 px-4 text-sm border border-black rounded-lg shadow-sm focus:ring-black focus:border-black"
                                    placeholder="Contact number" required>
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <div class="flex justify-center mt-8">
                            <button type="submit"
                                class="px-6 py-3 text-sm font-medium text-white bg-blue-600 rounded-lg shadow-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                                Create Company
                            </button>
                        </div>
                    </form>

                    <!-- Initialize Select2 -->
                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            $('#agency_id').select2({
                                placeholder: "Select Agency",
                                allowClear: true,
                                width: '100%' // Ensure it takes the full width
                            });
                        });
                    </script>




                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function openModal(id) {
        document.getElementById(id).classList.remove('hidden');
    }
</script>

<script>
    $(document).ready(function() {
        // Open Delete Modal
        window.openDeleteModal = function(recordId) {
            $('#deleteRecordId').val(recordId);
            $('#deleteModal').removeClass('hidden');
        };

        // Submit Delete Form
        $('#deleteForm').on('submit', function(e) {
            e.preventDefault();
            let recordId = $('#deleteRecordId').val();
            let deleteUrl = "{{ route('clients.destroy', ':id') }}".replace(':id', recordId);

            $.ajax({
                url: deleteUrl,
                type: "DELETE",
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    if (response.success) {
                        $('#successModal').removeClass('hidden'); // Show success modal
                        $('#deleteForm')[0].reset(); // Reset form
                        $('#deleteModal').addClass('hidden'); // Close modal
                        $('#employee-table').DataTable().ajax.reload(null,
                            false); // Reload table without resetting pagination
                    }
                },
                error: function(xhr) {
                    alert('Error deleting record.');
                }
            });
        });

        function closeModal(modalId, reopenButtonId) {
            $(modalId).addClass('hidden');

        }
        window.closeModal = function(modalId) {
            $('#' + modalId).addClass('hidden');
        };

    });
</script>



<div id="deleteModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
    <div class="bg-white rounded-lg shadow-lg p-6 w-auto md:w-[30rem] mt-20">
        <h2 class="mb-4 text-lg font-bold">Delete Record</h2>
        <p>Are you certain you want to delete this Client? Doing so will affect
            the
            related
            Employees.</p>
        <form id="deleteForm">
            @csrf
            <input type="hidden" id="deleteRecordId" name="id">
            <div class="flex justify-end mt-6">
                <button type="button" onclick="closeModal('deleteModal')"
                    class="px-4 py-2 mr-2 text-gray-700 bg-gray-200 rounded">Cancel</button>
                <button type="submit" class="px-4 py-2 text-white bg-red-600 rounded">Delete</button>
            </div>
        </form>
    </div>
</div>


<div id="successModal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
    <div class="p-5 bg-white rounded-lg shadow-lg w-96">
        <h2 class="text-lg font-bold text-center">Success</h2>
        <p class="mt-2 text-center text-gray-700">Data record added successfully!</p>
        <div class="mt-4 text-center">
            <button onclick="closeModal('successModal')"
                class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                OK
            </button>
        </div>
    </div>
</div>

<div id="editClientModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-black bg-opacity-50">
    <div class="w-1/2 mx-auto mt-10 overflow-hidden bg-white rounded-lg shadow-xl">
        <!-- Header -->
        <div class="flex items-center justify-between px-4 py-2 border-b">
            <h5 class="text-sm font-medium text-gray-900">Edit Client</h5>
            <button onclick="closeModal('editClientModal')">&times;</button>
        </div>

        <!-- Form -->
        <div class="w-full p-8">
            <form id="editClientForm" method="POST">
                @csrf
                @method('PUT')
                <input type="hidden" id="edit_client_id">

                <div class="grid grid-cols-2 gap-4">
                    <!-- Agency Selection -->
                    <div>
                        <label for="edit_agency_id" class="block text-sm font-medium text-gray-700">Select
                            Agency</label>
                        <select name="agency_id" id="edit_agency_id"
                            class="w-full h-10 px-3 border border-black rounded-md">
                            <option value="">Select Agency</option>
                            @foreach ($companies as $company)
                                <option value="{{ $company->id }}">{{ $company->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Business Name -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Business Name</label>
                        <input type="text" id="edit_business_name" name="business_name"
                            class="w-full h-10 px-3 border border-black rounded-md">
                    </div>

                    <!-- Contact Phone -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Contact Phone</label>
                        <input type="text" id="edit_contact_phone" name="contact_number"
                            class="w-full h-10 px-3 border border-black rounded-md">
                    </div>

                    <!-- Address -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Address</label>
                        <input type="text" id="edit_address" name="address"
                            class="w-full h-10 px-3 border border-black rounded-md">
                    </div>
                </div>

                <div class="flex justify-center mt-6">
                    <button type="submit"
                        class="px-4 py-2 text-white bg-green-600 rounded-md hover:bg-green-700">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    window.routes = {
        clientShow: @json(route('clients.show', ['client' => ':id'])),
        clientUpdate: @json(route('clients.update', ['client' => ':id']))
    };
</script>
<script>
    function openEditModal(id) {
        let url = window.routes.clientShow.replace(':id', id);

        axios.get(url)
            .then(response => {
                let client = response.data;

                // Populate form fields
                document.getElementById('edit_client_id').value = client.id;
                document.getElementById('edit_business_name').value = client.business_name;
                document.getElementById('edit_contact_phone').value = client.contact_number ?? '';
                document.getElementById('edit_address').value = client.address;

                // Set agency dropdown
                $('#edit_agency_id').val(client.agency_id).trigger('change');

                // Open modal
                document.getElementById('editClientModal').classList.remove('hidden');
            })
            .catch(error => {
                console.error(error);
                alert('Error fetching client data.');
            });
    }

    document.getElementById('editClientForm').addEventListener('submit', function(e) {
        e.preventDefault();

        let id = document.getElementById('edit_client_id').value;
        let url = window.routes.clientUpdate.replace(':id', id);

        let formData = new FormData(this);

        axios.post(url, formData, {
                headers: {
                    'X-HTTP-Method-Override': 'PUT'
                }
            })
            .then(response => {
                closeModal('editClientModal');
                $('#employee-table').DataTable().ajax.reload(null, false);
            })
            .catch(error => {
                console.error(error);
                alert('Error updating client.');
            });
    });
</script>
