   <h2 class="mb-6 font-bold text-md">Department List</h2>
   <div class="">

       <div class="col-span-3 overflow-auto">

           <table id="department-table" class="min-w-full border border-gray-200 rounded shadow-md ">
               <thead>
                   <tr class="text-sm leading-normal text-white  bg-[#1d1d1d]">
                       <th class="px-6 py-3">Department</th>
                       <th class="px-6 py-3">Number of Employees</th>

                       <th class="px-6 py-3">Actions</th>
                   </tr>
               </thead>
               <tbody class="text-sm font-light text-center text-gray-600">
               </tbody>
           </table>
       </div>
   </div>




   <script>
       $(document).ready(function() {
           var clientId = {{ $client->id }}; // Client ID is available

           // Initialize DataTable
           var departmentTable = $('#department-table').DataTable({
               processing: true,
               serverSide: true,
               ajax: {
                   url: "{{ route('de.index', ['id' => ':id']) }}".replace(':id', clientId),
                   data: function(d) {
                       d.client_id = clientId; // Send client ID as parameter if necessary
                   }
               },
               columns: [{
                       data: 'department_name',
                       name: 'department_name'
                   },
                   {
                       data: 'employee_count',
                       name: 'employee_count'
                   },

                   {
                       data: 'action',
                       name: 'action',
                       orderable: false,
                       searchable: false
                   }
               ],
               order: [
                   [0, 'desc']
               ]
           });
       });
   </script>
