<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Variance Report Reconciliation</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 10px;
            color: #333;
            font-size: 12px;
        }

        h1 {
            font-weight: bold;
            font-size: 16px;
            margin-bottom: 25px;
            text-align: center;
            text-transform: uppercase;
        }

        .header {
            display: flex;
            align-items: center;
            margin-bottom: 25px;
        }

        .header img {
            max-width: 80px;
            margin-right: 15px;
        }

        .agency-info p {
            margin: 1px 0;
            font-size: 12px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 11px;
            table-layout: fixed;
        }

        th,
        td {
            padding: 4px 6px;
            text-align: left;
            vertical-align: top;
        }

        th {
            background-color: #f7f7f7;
            font-weight: 600;
        }

        .text-red {
            color: #b91c1c;
            font-weight: 600;
        }

        .text-green {
            color: #15803d;
            font-weight: 600;
        }

        .footer {
            font-size: 11px;
            margin-top: 30px;
        }

        .footer p {
            margin: 2px 0;
        }

        .note {
            font-style: italic;
            margin-top: 10px;
            font-size: 11px;
        }

        .table-row {
            border-bottom: 1px solid #e0e0e0;
        }
    </style>
</head>

<body>

    <div class="header">
        <img src="{{ $client->client->client->agency->contact_person }}" alt="Agency Logo" />
        <div class="agency-info">
            <p><strong>{{ $client->client->client->agency->name }}</strong></p>
            <p>{{ $client->client->client->agency->address }}</p>
            <p>Telephone: {{ $client->client->client->agency->contact_phone }}</p>
        </div>
    </div>

    <h1>Variance Report Reconciliation</h1>

    @if (count($adjustment) > 0)
        <table>
            <thead>
                <tr>
                    <th style="width: 10%;">Batch ID</th>
                    <th style="width: 20%;">Employee Name</th>
                    <th style="width: 15%;">Action</th>
                    <th style="width: 25%;">Remarks</th>
                    <th style="width: 10%;">Underpayment</th>
                    <th style="width: 10%;">Overpayment</th>
                    <th style="width: 10%;">Date</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($adjustment as $report)
                    <tr class="table-row">
                        <td>{{ $report->batch_id }}</td>
                        <td>
                            {{ $report->employee->first_name }} {{ substr($report->employee->middle_name, 0, 1) }}.
                            {{ $report->employee->last_name }}
                        </td>
                        <td>{{ $report->action }}</td>
                        <td>{{ $report->remarks }}</td>
                        <td class="text-red">₱{{ number_format($report->underpayment ?? 0, 2) }}</td>
                        <td class="text-green">₱{{ number_format($report->overpayment ?? 0, 2) }}</td>
                        <td>{{ \Carbon\Carbon::parse($report->created_at)->format('M d, Y') }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <p>No variance records were found for this batch.</p>
    @endif

    @if ($hasBillingRecords && $hasBillingRecords->note != null)
        <p class="note"><strong>Note:</strong> {{ $hasBillingRecords->note }}</p>
    @endif

    @if ($hasBillingRecords)
        <div class="footer">
            <p><strong>Prepared By:</strong> {{ $hasBillingRecords->user->name }}</p>
            <p><strong>Date Prepared:</strong> {{ \Carbon\Carbon::now()->format('F d, Y') }}</p>
        </div>
    @endif

</body>

</html>
