@if (session('success'))
    <div id="successModal" class="fixed inset-0 z-50 flex items-start  justify-center bg-black bg-opacity-50">
        <div
            class="relative flex flex-col items-center justify-center mt-20 w-full max-w-md p-6 bg-white rounded-lg shadow-lg animate-fadeIn">
            <!-- Success Icon -->
            <i class="bx bxs-check-circle text-green-500 text-6xl mb-3"></i>

            <!-- Success Message -->
            <p class="mb-5 text-lg font-semibold text-center text-gray-800">
                {{ session('success') }}
            </p>

            <!-- Close Button -->
            <button onclick="closeModal()"
                class="px-4 py-2 text-white bg-green-500 rounded-md hover:bg-green-600 transition duration-300">
                OK
            </button>

            <!-- Close (X) Icon -->
            <button onclick="closeModal()" class="absolute top-3 right-3 text-gray-500 hover:text-gray-700">
                <i class="bx bx-x text-2xl"></i>
            </button>
        </div>
    </div>

    <script>
        function closeModal() {
            document.getElementById('successModal').classList.add('animate-fadeOut');
            setTimeout(() => document.getElementById('successModal').style.display = 'none', 300);
        }

        // Auto close after 2 seconds
        setTimeout(closeModal, 2000);
    </script>

    <style>
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes fadeOut {
            from {
                opacity: 1;
                transform: translateY(0);
            }

            to {
                opacity: 0;
                transform: translateY(-10px);
            }
        }

        .animate-fadeIn {
            animation: fadeIn 0.3s ease-out;
        }

        .animate-fadeOut {
            animation: fadeOut 0.3s ease-out forwards;
        }
    </style>
@endif










<script>
    function printDiv(divId) {
        var printContents = document.getElementById(divId).innerHTML;
        var originalContents = document.body.innerHTML;

        // Temporarily update the body content for printing
        document.body.innerHTML = printContents;

        // Create a link tag to import Poppins font from Google Fonts
        var link = document.createElement('link');
        link.href = "https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap";
        link.rel = "stylesheet";
        document.head.appendChild(link);

        // Apply print styles
        var style = document.createElement('style');
        style.innerHTML = `
        @media print {
            /* Specify custom paper size (e.g., 15cm x 30cm) */
            @page {
                size: 50cm 40cm;  /* Custom paper size (width x height in cm) */
                margin: 1cm;       /* Adjust margins as necessary */
            }

            /* Ensure the body has the correct styles for printing */
            body {
                font-family: 'Poppins', sans-serif;  /* Use Poppins font */
                font-size: 12pt;                    /* Set font size for printing */
                padding: 0;
                margin: 0;
                width: 100%;
            }

            /* Ensure all content is handled correctly for printing */
            * {
                box-sizing: border-box;
            }

            /* Make sure the table is responsive and fits within the page */
            table {
                width: 100% !important;  /* Ensure table width adjusts to the page */
                border-collapse: collapse;
                page-break-inside: auto;  /* Allow page breaks inside tables */
            }

            /* Handle page breaks between content blocks */
            .content {
                page-break-before: always;
            }

            /* Prevent table rows from breaking in the middle */
            tr {
                page-break-inside: avoid; /* Avoid breaking rows between pages */
            }
        }
    `;
        document.head.appendChild(style);

        // Trigger the print dialog
        window.print();

        // Restore the original page content after printing
        document.body.innerHTML = originalContents;
    }
</script>
<div id="confirmationModal"
    class="fixed inset-0 z-50 flex items-center justify-center hidden bg-gray-800 bg-opacity-75">
    <div class="p-6 bg-white rounded-lg shadow-lg w-96">
        <h2 class="text-lg font-semibold">Confirm Save</h2>
        <p>Are you sure you want to save? Saving will serve as a final billing.</p>
        <div class="flex justify-end mt-4 space-x-2">
            <button id="cancelButton" class="px-4 py-2 text-white bg-gray-500 rounded-md hover:bg-gray-600">
                Cancel
            </button>
            <button id="confirmButton" class="px-4 py-2 text-white bg-blue-500 rounded-md hover:bg-blue-700">
                Confirm
            </button>
        </div>
    </div>
</div>

<!-- JavaScript to handle modal and form submission -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('form2'); // Your form ID
        const confirmationModal = document.getElementById('confirmationModal');
        const confirmButton = document.getElementById('confirmButton');
        const cancelButton = document.getElementById('cancelButton');

        // Handle form submit to show confirmation modal
        form.addEventListener('submit', function(event) {
            event.preventDefault(); // Prevent the form from submitting

            // Show the confirmation modal
            confirmationModal.classList.remove('hidden');
        });

        // If confirmed, submit the form
        confirmButton.addEventListener('click', function() {
            confirmationModal.classList.add('hidden'); // Hide the modal
            form.submit(); // Proceed with form submission
        });

        // If cancelled, hide the modal
        cancelButton.addEventListener('click', function() {
            confirmationModal.classList.add('hidden'); // Close the modal
        });
    });
</script>
