@extends('layouts.sidebar')
@section('title', 'billings')
@section('content')
    @if (in_array('Billing Checking' || 'Client Interface', $privileges))


        <div class="bg-white ">
            <div class="flex items-end justify-end gap-5">

                <button onclick="printDiv('print-section')"
                    class="px-4 py-2 font-bold text-white bg-gray-900 rounded-md w-44 hover:bg-blue-700">
                    Print
                </button>



            </div>

            <div class="p-6 mx-auto print-content " id="print-section">
                <div class="p-5">
                    <div class="flex flex-col items-center justify-center font-serif text-2xl text-center md:mb-10">
                        <img class="w-32" src="{{ asset($client->client->agency->contact_person) }}">
                        <p class="font-extrabold text-gray-800">{{ $client->client->agency->name }}</p>
                        <p class="text-sm text-gray-600">{{ $client->client->agency->address }}</p>
                        <p class="text-sm text-gray-600">Tel: {{ $client->client->agency->contact_phone }}</p>
                    </div>
                    <hr class="mb-4 border-t border-gray-300">
                    <div class="flex justify-between">
                        <div class="mb-4">
                            <p class="text-sm font-semibold text-gray-700">Client Name: <span
                                    class="font-normal text-gray-600">{{ $client->department_name }}</span></p>
                            <p class="text-sm font-semibold text-gray-700">Address: <span
                                    class="font-normal text-gray-600">{{ $client->client->address }}</span></p>
                            @if ($hasBillingRecords)
                                <p class="text-sm font-semibold text-gray-700">Billing Ref. #:
                                    <span class="font-normal text-gray-600"> {{ $hasBillingRecords->id }}</span>
                                </p>
                            @endif
                            <p class="text-sm font-semibold text-gray-700">Period Covered: <span
                                    class="font-normal text-gray-600">
                                    {{ \Carbon\Carbon::parse($batchCode->pay_period_start)->format('F d, Y') }} -
                                    {{ \Carbon\Carbon::parse($batchCode->pay_period_end)->format('F d, Y') }}
                                </span></p>
                        </div>
                        <div class="flex flex-col items-center gap-1 text-xs text-center">
                            <!-- Toggle View Buttons -->
                            <div class="flex justify-center w-full mb-2 space-x-4">
                                @php
                                    $batchcode = App\Models\Batchcode::find($batchCode->id);
                                @endphp
                                @if (request()->query('value') == 1)
                                    <form>
                                        <input type="hidden" name="value" value="">
                                        <button
                                            class="px-4 py-2 w-[15rem] text-white bg-blue-500 rounded hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-400 focus:ring-opacity-50">
                                            Back to Default View
                                        </button>
                                    </form>
                                @elseif($batchcode->with_adjustment == 1)
                                    <form>
                                        <input type="hidden" name="value" value="1">
                                        <button
                                            class="px-4 py-2 w-[15rem] text-white bg-blue-500 rounded hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-400 focus:ring-opacity-50">
                                            View Adjustments
                                        </button>
                                    </form>
                                @endif


                            </div>

                            <!-- Export Payroll Button -->
                            <div class="flex justify-center w-full mb-2">
                                <a href="{{ route('export.payroll', ['id' => $id, 'client_id' => $client->id]) }}"
                                    class="px-4 py-2 w-[15rem] text-white bg-blue-500 rounded hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-400 focus:ring-opacity-50">
                                    Export Payroll
                                </a>
                            </div>

                            @if (request()->query('value') == 1 && $batchcode->with_adjustment == 1)
                                <div class="flex justify-center w-full mb-2">
                                    <!-- Button to trigger the modal -->
                                    <button id="openModalButton" onclick="openModal('adjustmentModal')"
                                        class="px-4 py-2 w-[15rem] text-white bg-blue-500 rounded hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-400 focus:ring-opacity-50">
                                        Open Adjustment Modal
                                    </button>
                                </div>
                            @endif
                            <!-- Include the modal content -->
                            @include('Admin.Client.Billings.adjustment')
                        </div>



                    </div>

                    <hr class="mb-4 border-t border-gray-300">
                    <div class="hidden">
                        <input type="text" class="form-control" name="user_id" value="{{ $currentUser->id }}" required>
                        <input type="date" class="form-control" name="date" value="{{ date('Y-m-d') }}" required>
                    </div>
                    @php
                        // Collect all unique headers and initialize totals
                        $uniqueHeaders = [];
                        $totals = [
                            'others' => [],
                            'deductions' => [],
                            'benefits' => [],
                            'grand_total' => 0, // Track grand total
                            'grand_total_service' => 0, // Track grand total
                            'grand_total_vat' => 0,
                            'grand_total_with' => 0,
                        ];

                        $serviceamount = 0;
                        $withamount = 0;
                        $vatamountcharges = 0;
                        $ear1 = 0;
                        $ear2 = 0;
                        $ear3 = 0;
                        $chargeGroups = App\Models\ChargeGroup::where('charges_id', $latestCharge->id)
                            ->where('type', 'service')
                            ->get();
                        $chargeGroups2 = App\Models\ChargeGroup::where('charges_id', $latestCharge->id)
                            ->where('type', 'vat')
                            ->get();
                        $chargeGroups3 = App\Models\ChargeGroup::where('charges_id', $latestCharge->id)
                            ->where('type', 'with')
                            ->get();

                        foreach ($payrolls as $payroll) {
                            foreach ($payroll->othersForPayroll as $earning) {
                                $uniqueHeaders['others'][$earning->name] = $earning->name;
                            }
                            foreach ($payroll->trxConstantDeductions->where('status', 1) as $earning) {
                                // Get the description of the current deduction
                                $description = optional(App\Models\TrxCode::find($earning->trxConstant->group_code_id))
                                    ->description;
                                $uniqueHeaders['deductions'][$description] = $description;

                                // Initialize the amount accumulator for this deduction
                                $amount1 = 0;
                                $amount2 = 0;
                                $ear1 = 0;
                                $ear2 = 0;
                                $ear3 = 0;

                                $id = optional(App\Models\TrxCode::find($earning->trxConstant->group_code_id))->id;

                                foreach ($chargeGroups as $chargeGroup) {
                                    if ($id === $chargeGroup->group_code_id) {
                                        $matchingEarnings = $payroll->trxConstantDeductions->filter(
                                            fn($earning) => $earning->trxConstant->group_code_id ===
                                                $chargeGroup->group_code_id,
                                        );

                                        $amount1 = $matchingEarnings->sum('E_Amount');
                                    }
                                }

                                // Optionally, accumulate to grand total
                                $totals['grand_total_service'] += $amount1;
                                foreach ($chargeGroups2 as $chargeGroup) {
                                    if ($id === $chargeGroup->group_code_id) {
                                        // Find all matching earnings from trxConstantDeductions
                                        $matchingEarnings = $payroll->trxConstantDeductions->filter(
                                            fn($earning) => $earning->trxConstant->group_code_id ===
                                                $chargeGroup->group_code_id,
                                        );

                                        // Directly sum the E_Amount for matching earnings
                                        $amount2 = $matchingEarnings->sum('E_Amount');
                                    }
                                }

                                // Optionally, accumulate to grand total
                                $totals['grand_total_vat'] += $amount2 + $ear2;
                                foreach ($chargeGroups3 as $chargeGroup) {
                                    if ($id === $chargeGroup->group_code_id) {
                                        // Find all matching earnings from trxConstantDeductions
                                        $matchingEarnings = $payroll->trxConstantDeductions->filter(
                                            fn($earning) => $earning->trxConstant->group_code_id ===
                                                $chargeGroup->group_code_id,
                                        );

                                        // Directly sum the E_Amount for matching earnings
                                        $amount2 = $matchingEarnings->sum('E_Amount');
                                    }
                                }

                                // Optionally, accumulate to grand total
                                $totals['grand_total_with'] += $amount2 + $ear3;
                            }
                            foreach ($payroll->benefits as $earning) {
                                $uniqueHeaders['benefits'][$earning->type] = $earning->type;
                            }
                        }
                    @endphp

                    <div class="rounded-lg shadow-md ">
                        <table class="min-w-full border border-collapse border-gray-300 "
                            style="table-layout: fixed; width: 100%;">
                            <thead class="text-xs leading-normal text-gray-600 bg-gray-100">
                                <tr>
                                    <th class="py-2 text-xs text-left border border-gray-300"></th>
                                    <th class="px-3 py-2 text-xs text-left border border-gray-300">Employee Name</th>
                                    <th class="px-3 py-2 text-xs text-left border border-gray-300">Days</th>
                                    <th class="px-3 py-2 text-xs text-left border border-gray-300">Rate</th>
                                    <th class="px-3 py-2 text-xs text-left border border-gray-300">Amount</th>

                                    <!-- Render headers for Others, Deductions, and Benefits -->
                                    @foreach ($uniqueHeaders['others'] ?? [] as $header)
                                        <th class="px-3 py-2 text-xs text-left border border-gray-300">
                                            {{ $header }}
                                        </th>
                                    @endforeach

                                    @foreach ($uniqueHeaders['deductions'] ?? [] as $header)
                                        <th class="px-3 py-2 text-xs text-left border border-gray-300">
                                            {{ $header }}
                                        </th>
                                    @endforeach

                                    @foreach ($uniqueHeaders['benefits'] ?? [] as $header)
                                        <th class="px-3 py-2 text-xs text-left border border-gray-300">
                                            {{ $header }}
                                        </th>
                                    @endforeach

                                    <th class="px-3 py-2 text-xs text-left border border-gray-300">Grand Total</th>
                                </tr>
                            </thead>

                            <tbody class="text-xs font-light text-gray-700">
                                <!-- Render rows -->
                                @foreach ($payrolls as $payroll)
                                    @php
                                        if ($chargeGroups) {
                                            $hasServiceGroupCode18 = $chargeGroups->contains('group_code_id', 18);

                                            // Check if group_code_id 18 exists in chargeGroups2 (vat)
                                            $hasVatGroupCode18 = $chargeGroups2->contains('group_code_id', 18);
                                            $haswithGroupCode18 = $chargeGroups3->contains('group_code_id', 18);

                                            if ($hasServiceGroupCode18) {
                                                $ear1 += $payroll->earnings;
                                            }

                                            if ($hasVatGroupCode18) {
                                                $ear2 += $payroll->earnings;
                                            }
                                            if ($haswithGroupCode18) {
                                                $ear3 += $payroll->earnings;
                                            }
                                        }
                                    @endphp


                                    @php
                                        $value = request()->query('value');
                                        if ($payroll->days_adjustment == null || $value == null || $value == 0) {
                                            $days = $payroll->days_worked_withdeduction;
                                        } elseif ($value == 1) {
                                            $days = $payroll->days_adjustment;
                                        }

                                        if ($payroll->earnings_adjustment == null || $value == null || $value == 0) {
                                            $earnings = $payroll->earnings;
                                        } elseif ($value == 1) {
                                            $earnings = $payroll->earnings_adjustment;
                                        }

                                        if ($payroll->rate_adjustment == null || $value == null || $value == 0) {
                                            $valuerate = $payroll->rate;
                                        } elseif ($value == 1) {
                                            $valuerate = $payroll->rate_adjustment;
                                        }

                                        $basicEarnings = $valuerate * $days;
                                        $rowTotal = $basicEarnings; // Add earnings

                                        // Add other earnings to the row total (e.g., COLA, Allowances)
                                        foreach ($uniqueHeaders['others'] ?? [] as $header) {
                                            $others = $payroll->othersForPayroll->firstWhere('name', $header);

                                            // Default amount to 0
                                            $amount = 0;

                                            if ($others) {
                                                // If 'amount_adj' is null, or if $value is null or 0, use 'amount'
                                                if ($others->amount_adj === null || $value == null || $value == 0) {
                                                    $amount = $others->amount ?? 0; // Default to 0 if 'amount' is not set
                                                } elseif ($value == 1) {
                                                    // If $value is 1, use 'amount_adj'
                                                    $amount = $others->amount_adj ?? 0; // Default to 0 if 'amount_adj' is not set
                                                }
                                            }
                                            $rowTotal += $amount;
                                            $totals['others'][$header] = ($totals['others'][$header] ?? 0) + $amount;
                                        }

                                        // Subtract deductions (SSS, Pag-IBIG, PhilHealth)
                                        foreach ($uniqueHeaders['deductions'] ?? [] as $header) {
                                            $deduction = $payroll->trxConstantDeductions->firstWhere(
                                                fn($earning) => optional(
                                                    App\Models\TrxCode::find($earning->trxConstant->group_code_id),
                                                )->description === $header,
                                            );

                                            $amount = $deduction?->er_amount_ad ?? ($deduction?->E_Amount ?? 0);
                                            $rowTotal += $amount;
                                            $totals['deductions'][$header] =
                                                ($totals['deductions'][$header] ?? 0) + $amount;
                                        }

                                        // Add benefits (if applicable)
                                        foreach ($uniqueHeaders['benefits'] ?? [] as $header) {
                                            $benefits = $payroll->benefits->firstWhere('type', $header);

                                            // Default amount to 0
                                            $amount = 0;

                                            if ($benefits) {
                                                // If 'amount_adj' is null, or if $value is null or 0, use 'amount'
                                                if ($benefits->amount_adj === null || $value == null || $value == 0) {
                                                    $amount = $benefits->employer_share ?? 0; // Default to 0 if 'amount' is not set
                                                } elseif ($value == 1) {
                                                    // If $value is 1, use 'amount_adj'
                                                    $amount = $benefits->er_adjustment ?? 0; // Default to 0 if 'amount_adj' is not set
                                                }
                                            }

                                            $rowTotal += $amount;
                                            $totals['benefits'][$header] =
                                                ($totals['benefits'][$header] ?? 0) + $amount;
                                        }

                                        // Accumulate grand total
                                        $totals['grand_total'] += $rowTotal;
                                    @endphp



                                    <tr class="border-b border-gray-300 hover:bg-gray-100">
                                        <td class="py-1 text-xs border border-gray-300 ">
                                            <div class="relative flex items-start justify-center group">
                                                <!-- Button to trigger the menu -->
                                                <button
                                                    class="flex items-center justify-center w-6 h-6 bg-white rounded-full shadow menuButton hover:bg-gray-100">
                                                    <div class="flex flex-col justify-between w-1 h-4">
                                                        <span class="block w-1 h-1 bg-gray-700 rounded-full"></span>
                                                        <span class="block w-1 h-1 bg-gray-700 rounded-full"></span>
                                                        <span class="block w-1 h-1 bg-gray-700 rounded-full"></span>
                                                    </div>
                                                </button>

                                                <!-- Floating menu (hidden by default) -->
                                                <div
                                                    class="absolute z-50 hidden w-32 text-left transition-opacity duration-300 transform -translate-x-1/2 bg-white border border-gray-200 rounded shadow-lg opacity-0 menuPopup left-1/2 group-hover:block group-hover:opacity-100">
                                                    @if ($hasBillingRecords)
                                                        <p class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                                            Can't Edit</p>
                                                    @else
                                                        <a href="{{ route('billing.payroll.edit', $payroll->id) }}"
                                                            class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Edit
                                                        </a>
                                                    @endif
                                                    <a href="#action2"
                                                        class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">View
                                                    </a>

                                                </div>
                                            </div>
                                        </td>









                                        <td class="px-3 py-1 text-xs border border-gray-300">
                                            {{ $payroll->employee->first_name }}
                                            {{ substr($payroll->employee->middle_name, 0, 1) }}.
                                            {{ $payroll->employee->last_name }}
                                        </td>

                                        <td class="px-3 py-1 text-xs border border-gray-300">
                                            {{ $days }}
                                            @php
                                                // Initialize $total_days if it hasn't been defined earlier
                                                if (!isset($total_days)) {
                                                    $total_days = 0;
                                                }
                                                $servicegrandtotal = 0;
                                                $vatgrandtotal = 0;
                                                // Add the value of $days to $total_days
                                                $total_days += $days;

                                                if ($latestCharge->special_rate_service != null) {
                                                    $servicegrandtotal += $latestCharge->special_rate_service * $days;
                                                }

                                                if ($latestCharge->special_rate_vat != null) {
                                                    $vatgrandtotal += $latestCharge->special_rate_vat * $days;
                                                }

                                            @endphp






                                        </td>
                                        <td class="px-3 py-1 text-xs border border-gray-300">{{ $valuerate }}</td>
                                        <td class="px-3 py-1 text-xs border border-gray-300">{{ $earnings }}
                                        </td>

                                        <!-- Render Others for Payroll -->
                                        @foreach ($uniqueHeaders['others'] ?? [] as $header)
                                            @php
                                                $amount = '-';

                                                // Find the benefit with the given header type
                                                $others = $payroll->othersForPayroll->firstWhere('name', $header);

                                                if ($others) {
                                                    // Determine the amount based on conditions
                                                    if (is_null($others->amount_adj) || empty($value)) {
                                                        $amount = $others->amount ?? '-';
                                                    } elseif ($value == 1) {
                                                        $amount = $others->amount_adj ?? '-';
                                                    }

                                                    // If code_id is NOT NULL, match with chargeGroups
                                                    if (!is_null($others->code_id)) {
                                                        foreach ($chargeGroups as $groupcharge) {
                                                            if ($others->code_id == $groupcharge->group_code_id) {
                                                                $serviceamount +=
                                                                    $others->amount_adj ?? ($others->amount ?? 0);
                                                            }
                                                        }
                                                        foreach ($chargeGroups2 as $chargeGroup123) {
                                                            if ($others->code_id == $chargeGroup123->group_code_id) {
                                                                $vatamountcharges +=
                                                                    $others->amount_adj ?? ($others->amount ?? 0);
                                                            }
                                                        }
                                                        foreach ($chargeGroups3 as $groupcharge) {
                                                            if ($others->code_id == $groupcharge->group_code_id) {
                                                                $withamount +=
                                                                    $others->amount_adj ?? ($others->amount ?? 0);
                                                            }
                                                        }
                                                    }
                                                }
                                            @endphp

                                            <td class="px-3 py-1 text-xs border border-gray-300">
                                                {{ is_numeric($amount) ? number_format($amount, 2) : $amount }}
                                            </td>
                                        @endforeach


                                        <!-- Render Deductions -->
                                        @foreach ($uniqueHeaders['deductions'] ?? [] as $header)
                                            @php
                                                $deduction = $payroll->trxConstantDeductions->firstWhere(
                                                    fn($earning) => optional(
                                                        App\Models\TrxCode::find($earning->trxConstant->group_code_id),
                                                    )->description === $header,
                                                );

                                                $amount = $deduction?->er_amount_ad ?? ($deduction?->E_Amount ?? '-');
                                            @endphp
                                            <td class="px-3 py-1 text-xs border border-gray-300">
                                                {{ is_numeric($amount) ? number_format($amount, 2) : $amount }}
                                            </td>
                                        @endforeach


                                        @foreach ($uniqueHeaders['benefits'] ?? [] as $header)
                                            @php
                                                // Default value is '-'
                                                $amount = '-';

                                                // Find the benefit with the given header type
                                                $benefit = $payroll->benefits->firstWhere('type', $header);

                                                // Check if the benefit exists
                                                if ($benefit) {
                                                    // If 'er_adjustment' is null or $value is null or 0, use 'employer_share'
                                                    if (
                                                        $benefit->er_adjustment === null ||
                                                        $value == null ||
                                                        $value == 0
                                                    ) {
                                                        $amount = $benefit->employer_share ?? '-';
                                                    } elseif ($value == 1) {
                                                        // If $value is 1, use 'er_adjustment'
                                                        $amount = $benefit->er_adjustment ?? '-';
                                                    }

                                                    $numericAmount = is_numeric($amount) ? floatval($amount) : 0;

                                                    switch (strtolower($header)) {
                                                        case 'sss':
                                                            if ($latestCharge->s_sss == 1) {
                                                                $serviceamount += $numericAmount;
                                                            }
                                                            if ($latestCharge->v_sss == 1) {
                                                                $vatamountcharges += $numericAmount;
                                                            }
                                                            if ($latestCharge->w_sss == 1) {
                                                                $withamount += $numericAmount;
                                                            }
                                                            break;

                                                        case 'philhealth':
                                                            if ($latestCharge->s_phil == 1) {
                                                                $serviceamount += $numericAmount;
                                                            }
                                                            if ($latestCharge->v_phil == 1) {
                                                                $vatamountcharges += $numericAmount;
                                                            }
                                                            if ($latestCharge->w_phil == 1) {
                                                                $withamount += $numericAmount;
                                                            }
                                                            break;

                                                        case 'pag-ibig':
                                                            if ($latestCharge->s_pagibig == 1) {
                                                                $serviceamount += $numericAmount;
                                                            }
                                                            if ($latestCharge->v_pagibig == 1) {
                                                                $vatamountcharges += $numericAmount;
                                                            }
                                                            if ($latestCharge->w_pagibig == 1) {
                                                                $withamount += $numericAmount;
                                                            }
                                                            break;
                                                    }
                                                }
                                            @endphp
                                            <td class="px-3 py-1 text-xs border border-gray-300">
                                                {{ is_numeric($amount) ? number_format($amount, 2) : $amount }}
                                            </td>
                                        @endforeach

                                        <!-- Grand Total column -->
                                        <td class="px-3 py-1 text-xs border border-gray-300">
                                            {{ number_format($rowTotal, 2) }}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>

                            <!-- Footer with totals -->
                            <tfoot>
                                <tr class="font-semibold bg-gray-100">
                                    <td class="px-3 py-1 text-xs text-left border border-gray-300">
                                    </td>

                                    <td class="px-3 py-1 text-xs text-left border border-gray-300">Total
                                    </td>
                                    <td class="px-3 py-1 text-xs text-left border border-gray-300">{{ $total_days }}
                                    </td>
                                    <td class="px-3 py-1 text-xs text-left border border-gray-300" colspan="2">
                                    </td>
                                    <!-- Render total for Others -->
                                    @foreach ($uniqueHeaders['others'] ?? [] as $header)
                                        <td class="px-3 py-1 text-xs border border-gray-300">
                                            {{ is_numeric($totals['others'][$header]) ? number_format($totals['others'][$header], 2) : '-' }}
                                        </td>
                                    @endforeach

                                    <!-- Render total for Deductions -->
                                    @foreach ($uniqueHeaders['deductions'] ?? [] as $header)
                                        <td class="px-3 py-1 text-xs border border-gray-300">
                                            {{ is_numeric($totals['deductions'][$header]) ? number_format($totals['deductions'][$header], 2) : '-' }}
                                        </td>
                                    @endforeach

                                    <!-- Render total for Benefits -->
                                    @foreach ($uniqueHeaders['benefits'] ?? [] as $header)
                                        <td class="px-3 py-1 text-xs border border-gray-300">
                                            {{ is_numeric($totals['benefits'][$header]) ? number_format($totals['benefits'][$header], 2) : '-' }}
                                        </td>
                                    @endforeach

                                    <!-- Grand Total Row -->
                                    <td class="px-3 py-1 text-xs border border-gray-300">
                                        {{ number_format($totals['grand_total'], 2) }}
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>


                    <p>Grand vat: {{ number_format($totals['grand_total_vat'] + $ear2 + $vatamountcharges, 2) }}</p>
                    <p>Grand service: {{ number_format($totals['grand_total_service'] + $ear1 + $serviceamount, 2) }}
                    </p>
                    <p>Grand with holding tax:
                        {{ number_format($totals['grand_total_with'] + $ear3 + $withamount, 2) }}
                    </p>


                    @php

                        $tatalservice = $totals['grand_total_service'] + $ear1 + $serviceamount;
                        $totalvat = $totals['grand_total_vat'] + $ear2 + $vatamountcharges;
                        $totalwith = $totals['grand_total_with'] + $ear3 + $withamount;

                    @endphp





                    @php

                        if ($latestCharge->special_rate_service != null) {
                            if ($latestCharge->service_charge_type == 'percentage') {
                                $service_charge = $servicegrandtotal * ($latestCharge->service_charge / 100);
                                $subtotal = $service_charge + $totals['grand_total'];
                            } elseif ($latestCharge->service_charge_type == 'amount') {
                                $service_charge = $servicegrandtotal * $latestCharge->charge_amount;
                                $subtotal = $service_charge + $totals['grand_total'];
                            } elseif ($latestCharge->s_computation_for_all == '1') {
                                $service_charge = $totals['grand_total'] * $latestCharge->charge_amount;
                                $subtotal = $service_charge + $totals['grand_total'];
                            }
                        }

                        if ($latestCharge->special_rate_service == null && $latestCharge->s_camputation_for_all == 1) {
                            if ($latestCharge->service_charge_type == 'percentage') {
                                $service_charge = $totals['grand_total'] * ($latestCharge->service_charge / 100);
                                $subtotal = $service_charge + $totals['grand_total'];
                            } elseif ($latestCharge->service_charge_type == 'amount') {
                                $service_charge = $totals['grand_total'] * $latestCharge->charge_amount;
                                $subtotal = $service_charge + $totals['grand_total'];
                            } elseif ($latestCharge->s_computation_for_all == '1') {
                                $service_charge = $totals['grand_total'] * $latestCharge->charge_amount;
                                $subtotal = $service_charge + $totals['grand_total'];
                            }
                        }

                        if ($latestCharge->special_rate_service == null && $latestCharge->s_camputation_for_all != 1) {
                            if ($latestCharge->service_charge_type == 'percentage') {
                                $service_charge = $tatalservice * ($latestCharge->service_charge / 100);
                                $subtotal = $service_charge + $totals['grand_total'];
                            } elseif ($latestCharge->service_charge_type == 'amount') {
                                $service_charge = $tatalservice * $latestCharge->charge_amount;
                                $subtotal = $service_charge + $totals['grand_total'];
                            }
                        }

                        //vatt

                        if ($latestCharge->special_rate_vat != null) {
                            $vat_charge = $vatgrandtotal * ($latestCharge->vat / 100);
                            $subtotal1 = $vat_charge + $totals['grand_total'];
                        }

                        if ($latestCharge->special_rate_vat == null && $latestCharge->v_camputation_for_all == 1) {
                            $vat_charge = $totals['grand_total'] * ($latestCharge->vat / 100);
                            $subtotal1 = $vat_charge + $totals['grand_total'];
                        } elseif (
                            $latestCharge->special_rate_vat == null &&
                            $latestCharge->v_camputation_for_all != 1
                        ) {
                            $vat_charge = $totalvat * ($latestCharge->vat / 100);
                            $subtotal1 = $vat_charge + $totals['grand_total'];
                        }

                        $vatplusservice = $vat_charge + $service_charge + $totals['grand_total'];

                    @endphp



















                    @php

                        // if ($latestCharge->service_charge_type == 'percentage') {
                        //     $holding = $totals['grand_total'] * ($latestCharge->withholding_tax / 100);
                        //     $Amountbill = $vatplusservice - $holding;
                        // } else {
                        //     $holding = $totals['grand_total'] * ($latestCharge->withholding_tax / 100);
                        //     $Amountbill = $vatplusservice - $holding;
                        // }

                        if ($latestCharge->w_camputation_for_all == 1) {
                            $holding = $totals['grand_total'] * ($latestCharge->withholding_tax / 100);
                            $Amountbill = $vatplusservice - $holding;
                        } else {
                            $holding = $totalwith * ($latestCharge->withholding_tax / 100);
                            $Amountbill = $vatplusservice - $holding;
                        }

                    @endphp


                    <div class="flex items-center justify-end mt-8">
                        <div
                            class="grid grid-cols-1 gap-2 w-[24rem] p-4 bg-white shadow-md rounded-lg border border-gray-200">

                            <!-- Hidden Section for Inputs -->
                            <div class="hidden">
                                <label for="service_charge" class="text-xs font-semibold text-gray-600">Service Charge
                                    (%):</label>
                                <input type="number" id="service_charge" value="{{ $latestCharge->service_charge }}"
                                    class="p-2 text-xs border-2 border-gray-300 rounded-md" />

                                <label for="vat" class="text-xs font-semibold text-gray-600">VAT (%):</label>
                                <input type="number" id="vat" value="{{ $latestCharge->vat }}"
                                    class="p-2 text-xs border-2 border-gray-300 rounded-md" />

                                <label for="withholding_tax" class="text-xs font-semibold text-gray-600">Withholding
                                    Tax
                                    (%):</label>
                                <input type="number" id="withholding_tax" value="{{ $latestCharge->withholding_tax }}"
                                    class="p-2 text-xs border-2 border-gray-300 rounded-md" />
                            </div>


                            <div class="space-y-2">
                                <div class="flex items-center justify-between text-xs text-gray-700">
                                    <span>Service Charge <span id="display_service_charge_percent" class="text-gray-800">
                                            @if ($latestCharge->service_charge_type == 'percentage')
                                                {{ number_format($latestCharge->service_charge, 0, '.', '') }}%
                                            @else
                                                {{ $latestCharge->charge_amount }}
                                            @endif
                                        </span>

                                    </span>
                                    <span id="display_service_charge"
                                        class="text-right text-gray-800">{{ number_format($service_charge, 2, '.', ',') }}</span>
                                </div>

                                <!-- Subtotal -->
                                <div class="flex items-center justify-between text-xs text-gray-700">
                                    <span>Subtotal:</span>
                                    <span id="display_subtotal"
                                        class="text-right text-gray-800">{{ number_format($subtotal, 2, '.', ',') }}</span>
                                </div>
                                <div class="flex items-center justify-center">
                                    <p class="my-2">---------------------------------------</p>
                                </div>
                                <!-- VAT -->
                                <div class="flex items-center justify-between text-xs text-gray-700">
                                    <span>VAT <span id="display_vat_percent"
                                            class="text-gray-800">{{ number_format($latestCharge->vat, 0, '.', '') }}%</span></span>
                                    <span id="display_vat"
                                        class="text-right text-gray-800">{{ number_format($vat_charge, 2, '.', ',') }}</span>
                                </div>

                                <!-- Subtotal1 -->
                                <div class="flex items-center justify-between text-xs text-gray-700">
                                    <span>Subtotal:</span>
                                    <span id="display_subtotal1"
                                        class="text-right text-gray-800">{{ number_format($subtotal1, 2, '.', ',') }}</span>
                                </div>

                                <!-- Withholding Tax -->
                                <div class="flex items-center justify-between text-xs text-gray-700">
                                    <span>Withholding Tax <span id="display_withholding_tax_percent"
                                            class="text-gray-800">{{ number_format($latestCharge->withholding_tax, 0, '.', '') }}%</span>
                                    </span>
                                    <span id="display_holding_tax"
                                        class="text-right text-gray-800">{{ number_format($holding, 2, '.', ',') }}</span>
                                </div>

                                <!-- Amount Bill Payable -->
                                <div class="flex items-center justify-between text-xs font-semibold text-gray-800">
                                    <span>Amount Bill Payable:</span>
                                    <span id="display_amount_bill_payable"
                                        class="text-lg font-semibold">{{ number_format($Amountbill, 2, '.', ',') }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div>
                        @if ($hasBillingRecords)
                            @if ($hasBillingRecords->note != null)
                                <p><strong>Note: </strong>{{ $hasBillingRecords->note }}</p>
                            @endif
                            <p>Prepared by:<span> {{ $hasBillingRecords->user->name }}</span></p>
                        @endif
                    </div>
                    <div class="mt-10">
                        @if ($hasBillingRecords)
                            <p>This billing is already finalized.</p>
                        @else
                            <form id="form2" action="{{ route('billings.store') }}" method="POST">
                                @csrf
                                <div>
                                    <input type="hidden" id="batch_id" name="batch_id" value="{{ $batchCode->id }}"
                                        required class="p-2 border">
                                </div>
                                <input type="hidden" id="user_id" name="user_id" value="{{ auth()->user()->id }}">
                                <input type="hidden" id="charge_id" name="charge_id" value="{{ $latestCharge->id }}">

                                <div class="flex flex-col items-center justify-center">
                                    <div>
                                        <label for="note">Note:</label>
                                        <textarea id="note" name="note" class="p-2 border"></textarea>
                                    </div>

                                    <div>
                                        <button type="submit" class="px-4 py-2 mt-4 text-white bg-green-500 rounded-md">
                                            Save Billing
                                        </button>
                                    </div>
                                </div>
                            </form>
                        @endif
                    </div>
                </div>
            </div>
            <div class="my-4 text-center">
                <div class="hidden"> <input name="status" value="1">
                    <input name="client_id" value="{{ $client_id }}">
                    <input name="id" value="{{ $id }}">
                </div>

            </div>
        </div>


        @include('Admin.Client.Billings.js')
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i> <!-- Large lock icon indicating no access -->
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif







@endsection
