@extends('layouts.sidebar')

@section('title', 'Edit Billing')
@section('content')
    <div class="container">
        <h2 class="mb-4 text-3xl font-extrabold text-gray-800 leading-tight">Edit Billing</h2>

        <p class="mb-6 text-lg text-gray-600">
            <span class="font-medium text-gray-800">Employee Name:</span>
            <span class="text-gray-900">
                {{ $payroll->employee->first_name }}
                {{ strtoupper(substr($payroll->employee->middle_name, 0, 1)) }}.
                {{ $payroll->employee->last_name }}
            </span>
        </p>


        @if (session('success'))
            <div id="successModal" class="fixed inset-0 z-50 flex items-start justify-center bg-gray-900 bg-opacity-50">
                <div
                    class="flex flex-col items-center justify-center w-full max-w-2xl p-6 mt-20 bg-white rounded-lg shadow-lg">
                    <i class='text-6xl bx bxs-check-circle'></i>
                    <p class="mb-5 text-lg font-semibold text-center">
                        {{ session('success') }}
                    </p>

                </div>
            </div>
            <script>
                setTimeout(function() {
                    document.getElementById('successModal').style.display = 'none';
                }, 2000); // 5000 milliseconds = 5 seconds
            </script>
        @endif

        <form action="{{ route('company-billings.update', $payroll->id) }}" method="POST" class="space-y-8">
            @csrf
            @method('PUT')

            <!-- Global Error Messages -->
            @if ($errors->any())
                <div class="bg-red-600 text-white p-4 rounded-lg shadow-md">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li class="text-sm">{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @php

                if ($payroll->days_adjustment == null) {
                    $value = $payroll->days_worked_withdeduction;
                } else {
                    $value = $payroll->days_adjustment;
                }

                if ($payroll->rate_adjustment == null) {
                    $valuerate = $payroll->rate;
                } else {
                    $valuerate = $payroll->rate_adjustment;
                }
            @endphp
            <div class="mb-6">
                <label for="basic_salary" class="block text-sm font-medium text-gray-700">Basic Salary</label>
                <div class="flex gap-6 mt-2">
                    <div class="flex-1">
                        <label for="days_worked_withdeduction" class="block text-xs text-gray-600">Days Worked (With
                            Deduction)</label>
                        <input type="text" id="days_worked_withdeduction" name="days_worked_withdeduction"
                            value="{{ old('days_worked_withdeduction', $value) }}"
                            class="block w-full p-3 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 @error('days_worked_withdeduction') border-red-500 @enderror">
                        @error('days_worked_withdeduction')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="flex-1">
                        <label for="rate" class="block text-xs text-gray-600">Rate</label>
                        <input type="text" id="rate" name="rate" value="{{ old('rate', $valuerate) }}"
                            class="block w-full p-3 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 @error('rate') border-red-500 @enderror">
                        @error('rate')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 gap-6 xl:grid-cols-3">

                <!-- Constant Earnings -->
                <div class="border-2 border-gray-300 rounded-lg p-4 shadow-md">
                    <label for="constant_deductions" class="block text-sm font-medium text-gray-700 mb-2">Constant
                    </label>
                    @foreach ($constantearning as $constant)
                        @php
                            $trxcode = \App\Models\Trxcode::find($constant->trxConstant->group_code_id);
                            $value = $constant->er_amount_ad ?? $constant->E_Amount;
                        @endphp
                        <div class="flex flex-col gap-6 md:flex-row">
                            <div class="flex-1">
                                <input type="text" readonly name="constant_deductions[name][]"
                                    value="{{ $trxcode->description }}"
                                    class="block w-full p-3 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none">
                            </div>
                            <div class="flex-1">
                                <input type="text" name="constant_deductions[amount][]"
                                    value="{{ old('constant_deductions.amount.' . $loop->index, $value) }}"
                                    class="block w-full p-3 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 @error('constant_deductions.amount.' . $loop->index) border-red-500 @enderror">
                                @error('constant_deductions.amount.' . $loop->index)
                                    <span class="text-red-500 text-sm">{{ $message }}</span>
                                @enderror
                            </div>
                            <input type="hidden" name="constant_deductions[id][]" value="{{ $constant->id }}">
                        </div>
                    @endforeach
                </div>

                <!-- Loan Deductions -->
                <div class="border-2 border-gray-300 rounded-lg p-4 shadow-md">
                    <label for="loan_deductions" class="block text-sm font-medium text-gray-700 mb-2">Loan
                        Deductions</label>
                    @foreach ($loan_deductions as $loan)
                        @php
                            $trxcode = \App\Models\Trxcode::find($loan->trxLoan->group_code_id);

                            if ($loan->amount_ad == null) {
                                $value = $loan->Amount;
                            } else {
                                $value = $loan->amount_ad;
                            }
                        @endphp
                        <div class="flex flex-col gap-6 md:flex-row">
                            <div class="flex-1">
                                <input type="text" readonly name="loan_deductions[name][]"
                                    value="{{ $trxcode->description }}"
                                    class="block w-full p-3 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none">
                            </div>
                            <div class="flex-1">
                                <input type="text" name="loan_deductions[amount][]"
                                    value="{{ old('loan_deductions.amount.' . $loop->index, $value) }}"
                                    class="block w-full p-3 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 @error('loan_deductions.amount.' . $loop->index) border-red-500 @enderror">
                                @error('loan_deductions.amount.' . $loop->index)
                                    <span class="text-red-500 text-sm">{{ $message }}</span>
                                @enderror
                            </div>
                            <input type="hidden" name="loan_deductions[id][]" value="{{ $loan->id }}">
                        </div>
                    @endforeach
                </div>

                <!-- Other Deductions -->
                <div class="border-2 border-gray-300 rounded-lg p-4 shadow-md">
                    <label for="others" class="block text-sm font-medium text-gray-700 mb-2">Other Deductions</label>
                    @foreach ($others as $other)
                        @php

                            if ($other->amount_adj == null) {
                                $value = $other->amount;
                            } else {
                                $value = $other->amount_adj;
                            }
                        @endphp


                        <div class="flex flex-col gap-6 md:flex-row">
                            <div class="flex-1">
                                <input type="text" name="others[name][]"
                                    value="{{ old('others.name.' . $loop->index, $other->name) }}"
                                    class="block w-full p-3 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 @error('others.name.' . $loop->index) border-red-500 @enderror">
                                @error('others.name.' . $loop->index)
                                    <span class="text-red-500 text-sm">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="flex-1">
                                <input type="text" name="others[amount][]"
                                    value="{{ old('others.amount.' . $loop->index, $value) }}"
                                    class="block w-full p-3 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 @error('others.amount.' . $loop->index) border-red-500 @enderror">
                                @error('others.amount.' . $loop->index)
                                    <span class="text-red-500 text-sm">{{ $message }}</span>
                                @enderror
                            </div>
                            <input type="hidden" name="others[id][]" value="{{ $other->id }}">
                        </div>
                    @endforeach
                </div>

                <!-- Benefits -->
                <div class="border-2 border-gray-300 rounded-lg p-4 shadow-md">
                    <label for="benefits" class="block text-sm font-medium text-gray-700 mb-2">Benefits</label>
                    @foreach ($benefits as $benefit)
                        @php

                            if ($benefit->er_adjustment == null) {
                                $value = $benefit->employer_share;
                            } else {
                                $value = $benefit->er_adjustment;
                            }
                        @endphp
                        <div class="flex flex-col gap-6 md:flex-row">
                            <div class="flex-1">
                                <input type="text" name="benefits[type][]"
                                    value="{{ old('benefits.type.' . $loop->index, $benefit->type) }}"
                                    class="block w-full p-3 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 @error('benefits.type.' . $loop->index) border-red-500 @enderror">
                                @error('benefits.type.' . $loop->index)
                                    <span class="text-red-500 text-sm">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="flex-1">
                                <input type="text" name="benefits[employee_share][]"
                                    value="{{ old('benefits.employee_share.' . $loop->index, $value) }}"
                                    class="block w-full p-3 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 @error('benefits.employee_share.' . $loop->index) border-red-500 @enderror">
                                @error('benefits.employee_share.' . $loop->index)
                                    <span class="text-red-500 text-sm">{{ $message }}</span>
                                @enderror
                            </div>
                            <input type="hidden" name="benefits[id][]" value="{{ $benefit->id }}">
                        </div>
                    @endforeach
                </div>

            </div>

            <!-- Submit and Cancel buttons -->
            <div class="flex justify-end space-x-4 mt-6">
                <button type="submit"
                    class="px-6 py-3 bg-blue-600 text-white text-sm font-semibold rounded-lg shadow-lg hover:bg-blue-700 focus:ring-4 focus:ring-blue-300">
                    Update
                </button>
                @php
                    $code = \App\Models\Batchcode::find($payroll->code_id);
                @endphp
                <a href="{{ url('admin/company-billings/' . $payroll->code_id . '/' . $code->department_id . '/' . '?value=1') }}"
                    class="px-6 py-3 bg-gray-600 text-white text-sm font-semibold rounded-lg shadow-lg hover:bg-gray-700 focus:ring-4 focus:ring-gray-300">
                    Back
                </a>

            </div>

        </form>




    </div>


@endsection
