<script>
    document.addEventListener('DOMContentLoaded', function() {
        var daysWorkedInputs = document.querySelectorAll('.days-worked');
        var benefitFields = ['sss', 'pagibig', 'philhealth'];
        daysWorkedInputs.forEach(function(input) {
            input.addEventListener('input', function() {
                var dataId = this.getAttribute('data-id');
                var daysWorked = parseFloat(this.value) || 0;
                var salary = parseFloat(document.getElementById('salary_' + dataId).value) || 0;
                var newNetPay = daysWorked * salary;
                var newGrossPay = newNetPay;
                document.getElementById('net_pay_' + dataId).value = newNetPay.toFixed(2);
                document.getElementById('gross_pay_' + dataId).value = newGrossPay.toFixed(2);
                var total13 = newGrossPay / 12;
                var total13Input = document.getElementById('total_13_' + dataId);
                if (total13Input) {
                    total13Input.value = total13.toFixed(2);
                }
                updateGrandTotal(dataId, newGrossPay, total13);
                updateFooterTotals();
            });
        });

        function updateGrandTotal(dataId, newGrossPay, total13) {
            var sssValue = parseFloat(document.getElementById('sss_' + dataId).value) || 0;
            var pagibigValue = parseFloat(document.getElementById('pagibig_' + dataId).value) || 0;
            var philhealthValue = parseFloat(document.getElementById('philhealth_' + dataId).value) || 0;
            var gTotal = newGrossPay + total13 + sssValue + pagibigValue + philhealthValue;
            document.getElementById('g_total_' + dataId).value = gTotal.toFixed(2);
        }
        benefitFields.forEach(function(benefit) {
            var inputs = document.querySelectorAll('.' + benefit);
            inputs.forEach(function(input) {
                input.addEventListener('input', function() {
                    var dataId = this.getAttribute('data-id');
                    var newGrossPay = parseFloat(document.getElementById('gross_pay_' +
                        dataId).value) || 0;
                    var total13 = parseFloat(document.getElementById('total_13_' +
                        dataId).value) || 0;
                    updateGrandTotal(dataId, newGrossPay, total13);
                    updateFooterTotals();
                });
            });
        });

        function updateFooterTotals() {
            var totalDays = 0,
                netPay = 0,
                grossPay = 0,
                total13Month = 0;
            var totalSSS = 0,
                totalPagibig = 0,
                totalPhilhealth = 0,
                totalGross = 0;
            document.querySelectorAll('.days-worked').forEach(function(input) {
                var dataId = input.getAttribute('data-id');
                totalDays += parseFloat(input.value) || 0;
                netPay += parseFloat(document.getElementById('net_pay_' + dataId).value) || 0;
                grossPay += parseFloat(document.getElementById('gross_pay_' + dataId).value) || 0;
                total13Month += parseFloat(document.getElementById('total_13_' + dataId).value) || 0;
                totalSSS += parseFloat(document.getElementById('sss_' + dataId).value) || 0;
                totalPagibig += parseFloat(document.getElementById('pagibig_' + dataId).value) || 0;
                totalPhilhealth += parseFloat(document.getElementById('philhealth_' + dataId).value) ||
                    0;
                totalGross += parseFloat(document.getElementById('g_total_' + dataId).value) || 0;
            });
            document.getElementById('footer_total_days').textContent = totalDays.toFixed(2);
            document.getElementById('footer_net_pay').textContent = netPay.toFixed(2);
            document.getElementById('footer_gross_pay').textContent = grossPay.toFixed(2);
            document.getElementById('footer_13_month').textContent = total13Month.toFixed(2);
            document.getElementById('footer_sss').textContent = totalSSS.toFixed(2);
            document.getElementById('footer_pagibig').textContent = totalPagibig.toFixed(2);
            document.getElementById('footer_philhealth').textContent = totalPhilhealth.toFixed(2);
            document.getElementById('footer_total_gross').textContent = totalGross.toFixed(2);

            updateBilling();
        }

        function updateBilling() {
            const totalGross = parseFloat(document.getElementById('footer_total_gross').textContent) || 0;
            const serviceChargePercent = parseFloat(document.getElementById('service_charge').value) || 0;
            const vatPercent = parseFloat(document.getElementById('vat').value) || 0;
            const withholdingTaxPercent = parseFloat(document.getElementById('withholding_tax').value) || 0;
            const total = totalGross;
            const serviceCharge = totalGross * (serviceChargePercent / 100);
            const subtotal = serviceCharge + totalGross;
            const vat = subtotal * (vatPercent / 100);
            const subtotal1 = subtotal + vat;
            const holding = subtotal1 * (withholdingTaxPercent / 100);
            const Amountbill = subtotal1 - holding;
            document.getElementById('display_total').innerText = total.toFixed(2).replace(
                /\B(?=(\d{3})+(?!\d))/g, ",");
            document.getElementById('display_service_charge').innerText = serviceCharge.toFixed(2).replace(
                /\B(?=(\d{3})+(?!\d))/g, ",");
            document.getElementById('display_subtotal').innerText = subtotal.toFixed(2).replace(
                /\B(?=(\d{3})+(?!\d))/g, ",");
            document.getElementById('display_vat').innerText = vat.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g,
                ",");
            document.getElementById('display_subtotal1').innerText = subtotal1.toFixed(2).replace(
                /\B(?=(\d{3})+(?!\d))/g, ",");
            document.getElementById('display_holding_tax').innerText = holding.toFixed(2).replace(
                /\B(?=(\d{3})+(?!\d))/g, ",");
            document.getElementById('display_amount_bill_payable').innerText = Amountbill.toFixed(2).replace(
                /\B(?=(\d{3})+(?!\d))/g, ",");
            document.getElementById('footer_total_gross').value = totalGross.toFixed(2);
        }
        document.getElementById('total_gross').addEventListener('input', updateBilling);
        document.getElementById('service_charge').addEventListener('input', updateBilling);
        document.getElementById('vat').addEventListener('input', updateBilling);
        document.getElementById('withholding_tax').addEventListener('input', updateBilling);
        updateBilling();
    });
</script>
