<!-- Modal -->
<div id="adjustmentModal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-gray-800 bg-opacity-50">
    <div class="bg-white rounded-lg p-6 w-[80rem] overflow-auto">
        <div id="printContent" class="p-2">
            <div class="flex items-center justify-start gap-10 mb-6 font-serif text-2xl ">
                <div><img class="w-32 mb-4" src="{{ asset($client->client->agency->contact_person) }}"></div>
                <div class="flex flex-col items-start">
                    <p class="font-extrabold text-gray-800">{{ $client->client->agency->name }}</p>
                    <p class="text-sm text-gray-600">{{ $client->client->agency->address }}</p>
                    <p class="text-sm text-gray-600">Tel: {{ $client->client->agency->contact_phone }}</p>
                </div>

            </div>
            @if ($hasBillingRecords)
                <div class="flex flex-col items-start mb-5 font-semibold">
                    <p class="">Billing Code: {{ $hasBillingRecords->id }}</p>
                </div>
            @endif
            <div class="mb-10">
                <p class="text-xl font-bold mb-4 text-gray-800">📊 Variance Report Reconciliation</p>

                @if (count($adjustment) > 0)
                    <div class="overflow-x-auto rounded-lg shadow">
                        <table class="min-w-full bg-white border border-gray-300 text-sm text-gray-700 table-fixed">
                            <thead class="bg-gray-100 text-xs uppercase tracking-wider text-gray-600">
                                <tr>
                                    <th class="px-4 py-3 border border-gray-300 text-left">Batch ID</th>
                                    <th class="px-4 py-3 border border-gray-300 text-left">Employee</th>
                                    <th class="px-4 py-3 border border-gray-300 text-left">Action</th>
                                    <th class="px-4 py-3 border border-gray-300 text-left">Remarks</th>
                                    <th class="px-4 py-3 border border-gray-300 text-left text-red-600">Underpayment
                                    </th>
                                    <th class="px-4 py-3 border border-gray-300 text-left text-green-600">Overpayment
                                    </th>
                                    <th class="px-4 py-3 border border-gray-300 text-left">Created At</th>
                                    <th class="px-4 py-3 border border-gray-300 text-left">Delete</th>
                                    {{-- New header --}}
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($adjustment as $report)
                                    <tr class="hover:bg-gray-50">
                                        <td class="px-4 py-3 border border-gray-300">{{ $report->batch_id }}</td>
                                        <td class="px-4 py-3 border border-gray-300">
                                            {{ $report->employee->first_name }}
                                            {{ substr($report->employee->middle_name, 0, 1) }}.
                                            {{ $report->employee->last_name }}
                                        </td>
                                        <td class="px-4 py-3 border border-gray-300">{{ $report->action }}</td>
                                        <td class="px-4 py-3 border border-gray-300">{{ $report->remarks }}</td>
                                        <td class="px-4 py-3 border border-gray-300 text-red-600 font-semibold">
                                            {{ number_format($report->underpayment ?? 0, 2) }}
                                        </td>
                                        <td class="px-4 py-3 border border-gray-300 text-green-600 font-semibold">
                                            {{ number_format($report->overpayment ?? 0, 2) }}
                                        </td>
                                        <td class="px-4 py-3 border border-gray-300 text-gray-500">
                                            {{ \Carbon\Carbon::parse($report->created_at)->format('M d, Y ') }}
                                        </td>
                                        <td class="px-4 py-3 border border-gray-300 text-center">
                                            <div class="flex items-center justify-center gap-3">
                                                <button
                                                    class="text-red-600 hover:text-red-800 font-semibold delete-adjustment-btn"
                                                    data-id="{{ $report->id }}"
                                                    data-url="{{ route('destroyadjustment.destroy', $report->id) }}">
                                                    Delete
                                                </button>

                                                @if ($report->status != 1)
                                                    <button
                                                        class="text-green-600 hover:text-green-800 font-semibold status-adjustment-btn"
                                                        data-id="{{ $report->id }}"
                                                        data-url="{{ route('saveadjustment.store', $report->id) }}">
                                                        Save
                                                    </button>
                                                @endif
                                            </div>
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>

                    </div>
                @else
                    <div class="text-gray-500 text-sm italic mt-4">No variance reports found.</div>
                @endif
            </div>

            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    const buttons = document.querySelectorAll('.delete-adjustment-btn');

                    buttons.forEach(button => {
                        button.addEventListener('click', function() {
                            const url = this.getAttribute('data-url');


                            axios.delete(url, {
                                    headers: {
                                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                                        'Accept': 'application/json'
                                    }
                                })
                                .then(response => {

                                    this.closest('tr').remove();
                                })
                                .catch(error => {

                                    alert('Failed to delete adjustment.');
                                });
                        });
                    });
                });
            </script>
            <div class="flex items-center justify-start">
                @if ($hasBillingRecords)
                    @if ($hasBillingRecords->note != null)
                        <p><strong>Note: </strong>{{ $hasBillingRecords->note }}</p>
                    @endif
                    <p>Prepared by:<span> {{ $hasBillingRecords->user->name }}</span></p>
                @endif
            </div>
        </div>

        <!-- Print and Close Buttons -->
        <div class="flex justify-end gap-4">

            <a href="{{ route('variantreport.report.download', ['batchId' => $batchCode->id]) }}"
                class="px-4 py-2 bg-green-600 text-white rounded hover:bg-green-700">
                Export PDF Report
            </a>

            <button onclick="closeModal('adjustmentModal')"
                class="px-4 py-2 text-white bg-red-500 rounded hover:bg-red-600">
                Close
            </button>
        </div>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const buttons = document.querySelectorAll('.status-adjustment-btn');

                buttons.forEach(button => {
                    button.addEventListener('click', function() {
                        const url = this.getAttribute('data-url');
                        const row = this.closest('tr');
                        const saveBtn = this;

                        axios.post(url, {}, {
                                headers: {
                                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                                    'Accept': 'application/json'
                                }
                            })
                            .then(response => {
                                if (response.data.success) {

                                    saveBtn.remove(); // hide Save button after successful save
                                } else {

                                }
                            })
                            .catch(error => {
                                alert('Failed to save adjustment.');
                                console.error(error);
                            });
                    });
                });
            });
        </script>
    </div>
</div>

<script>
    // JavaScript to open the modal dynamically based on ID
    function openModal(id) {
        document.getElementById(id).classList.remove('hidden');
    }

    // Function to close the modal dynamically based on ID
    function closeModal(id) {
        document.getElementById(id).classList.add('hidden');
    }

    function printModal(divId) {
        var printContents = document.getElementById(divId).innerHTML;
        var originalContents = document.body.innerHTML;

        document.body.innerHTML = printContents;
        window.print();
        document.body.innerHTML = originalContents;


    }
</script>
