@extends('layouts.sidebar')

@section('title', 'Billings')
@section('content')
    @if (in_array('Billing Checking', $privileges))
        <div class="w-full p-4 lg:w-full">
            <p class="mb-10 font-bold">For Billing Approval</p>
            <div class="p-2 overflow-auto border-2 border-black rounded-md ">
                <table id="billing-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md">
                    <thead>
                        <tr class="text-sm leading-normal text-white uppercase bg-black">
                            <th class="px-6 py-3">Batch Code</th>
                            <th class="px-6 py-3">Client</th>
                            <th class="px-6 py-3">Final Approval In charge</th>
                            <th class="px-6 py-3">Pay Period </th>
                            <th class="px-6 py-3">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="text-sm font-light text-center text-gray-600">
                        <!-- Data will be populated here by DataTables -->
                    </tbody>
                </table>
            </div>
        </div>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i>
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif
    <script>
        $(document).ready(function() {
            var employedTable = $('#billing-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('billings.index') }}",
                    data: function(d) {

                    }
                },
                columns: [{
                        data: 'id', // Adjust according to your Batch Code data
                        name: 'id'
                    },
                    {
                        data: 'client_id', // New column for Client ID
                        name: 'client_id'
                    },
                    {
                        data: 'approve_by', // New column for Client ID
                        name: 'approve_by'
                    },
                    {
                        data: 'pay_period', // Matches the field from your server response
                        name: 'pay_period'
                    },



                    {
                        data: 'action', // Matches the action column from your server response
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ],
                order: [
                    [0, 'desc'] // Orders by the first column (Batch Code) descending
                ]
            });
        });
    </script>
@endsection
