@extends('layouts.sidebar')
@section('title', 'Users')
@section('content')
    @if (in_array('Manage Client Banks', $privileges))
        <div class="grid grid-cols-1 gap-4 xl:grid-cols-6">
            <div class="col-span-2">
                <div class="py-4"> <a href="{{ route('client_bankprofile') }}"
                        class="inline-block px-4 py-2 text-white bg-blue-600 rounded hover:bg-blue-700 transition duration-300">
                        Client Bank Profile
                    </a></div>

                <div class="max-w-3xl p-2 mx-auto border-2 border-black rounded-lg">
                    <h2 class="font-bold">
                        {{ isset($bankProfile) ? 'Edit Bank Profile' : 'Create Bank Profile' }}
                    </h2>

                    <form id="bankProfileForm" method="POST" enctype="multipart/form-data" class="p-3">
                        @csrf
                        @if (isset($bankProfile))
                            @method('PUT')
                        @endif

                        <div class="flex justify-center mt-2 mb-3 ">
                            <input hidden type="text" name="sample">

                        </div>

                        <div class="grid grid-cols-1 gap-6 md:grid-cols-2">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Bank Name</label>
                                <input type="text" name="name" value="{{ old('name', $bankProfile->name ?? '') }}"
                                    class="w-full border-2 border-black " required>
                            </div>




                            <div>
                                <label class="block text-sm font-medium text-gray-700">Company Code</label>
                                <input type="text" name="code" value="{{ old('code', $bankProfile->code ?? '') }}"
                                    class="w-full border-2 border-black ">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700">SWIFT Code</label>
                                <input type="text" name="swift_code"
                                    value="{{ old('swift_code', $bankProfile->swift_code ?? '') }}"
                                    class="w-full border-2 border-black ">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700">Head Office</label>
                                <input type="text" name="head_office"
                                    value="{{ old('head_office', $bankProfile->head_office ?? '') }}"
                                    class="w-full border-2 border-black ">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700">Contact Email</label>
                                <input type="email" name="contact_email"
                                    value="{{ old('contact_email', $bankProfile->contact_email ?? '') }}"
                                    class="w-full border-2 border-black ">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700">Contact Phone</label>
                                <input type="text" name="contact_phone"
                                    value="{{ old('contact_phone', $bankProfile->contact_phone ?? '') }}"
                                    class="w-full border-2 border-black ">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700">Website</label>
                                <input type="url" name="website"
                                    value="{{ old('website', $bankProfile->website ?? '') }}"
                                    class="w-full border-2 border-black ">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Bank Logo</label>
                                <input type="file" name="logo" accept="image/*" class="w-full border-2 border-black ">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700">Description</label>
                                <textarea name="description" rows="4" class="w-full border-2 border-black rounded-md">{{ old('description', $bankProfile->description ?? '') }}</textarea>
                            </div>
                        </div>
                        <div class="flex justify-between mt-6">
                            <!-- Update Button -->
                            <button type="submit"
                                class="px-6 py-2 text-white bg-blue-600 rounded-md shadow hover:bg-blue-700">
                                {{ isset($bankProfile) ? 'Update' : 'Create' }}
                            </button>
                        </div>
                    </form>


                </div>
            </div>
            <div class="col-span-4 p-6 rounded-md shadow-md">
                <h2 class="mb-4 text-2xl font-semibold text-gray-700">Bank Profiles</h2>

                <table id="bankProfilesTable" class="min-w-full text-center border border-gray-200 rounded-md table-auto">
                    <thead class="bg-gray-100">
                        <tr class="">
                            <th class="px-4 py-2">ID</th>
                            <th class="px-4 py-2">Bank Name</th>

                            <th class="px-4 py-2">Code</th>
                            <th class="px-4 py-2">SWIFT</th>
                            <th class="px-4 py-2">Phone</th>
                            <th class="px-4 py-2">Logo</th>


                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
        {{-- <div class="p-8 text-center bg-white rounded-lg shadow-lg">
        <h1 class="mb-4 text-xl font-semibold">BPI Payroll Export</h1>
        <p class="mb-6 text-gray-600">Select a client and date range to generate the payroll file.</p>

        <form id="formfilter" action="{{ route('bpi.export.header') }}" method="GET"
            class="flex flex-col flex-wrap items-center justify-center gap-4 md:flex-row">


            <input type="text" name="id" value="{{ old('id', $bankProfile->id ?? '') }}"
                class="w-full border-2 border-black " required>


            <div>
                <label for="client_id" class="block text-sm font-medium text-gray-700">Client</label>
                <select name="client_id" id="client_id" class="w-48 px-3 py-2 border-gray-300 rounded" required>
                    <option value="">Select Client</option>
                    @foreach ($clients as $client)
                        <option value="{{ $client->id }}">{{ $client->department_name }}</option>
                    @endforeach
                </select>
            </div>

            <div>
                <label for="from_date" class="block text-sm font-medium text-gray-700">From</label>
                <input type="date" id="from_date" name="from_date" class="w-48 px-3 py-2 border-gray-300 rounded"
                    required>
            </div>

            <div>
                <label for="to_date" class="block text-sm font-medium text-gray-700">To</label>
                <input type="date" id="to_date" name="to_date" class="w-48 px-3 py-2 border-gray-300 rounded"
                    required>
            </div>

            <button type="submit"
                class="px-6 py-3 mt-4 text-white transition-all duration-300 transform bg-blue-600 rounded hover:bg-blue-700 hover:scale-105 md:mt-6">
                Download Header File
            </button>
        </form>
    </div> --}}
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i>
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif
    @include('Admin.BankProfiles.js')



@endsection
