@extends('layouts.sidebar')
@section('title', 'Attendance')
@section('content')
    @if (in_array('Manage Attendance', $privileges))
        @include('Admin.Attendance.complete.modal')
        <div class="flex flex-col justify-between py-5 md:flex-row">
            <h1 class="mb-4 text-xl font-bold">Overtime Request</h1>

        </div>
        <div class="overflow-auto ">

            <table id="agencyTable" class="min-w-full bg-white border border-gray-200 rounded shadow-md ">
                <thead>
                    <tr class="text-sm leading-normal  text-white uppercase bg-[#1d1d1d]">
                        <th>Employee ID</th>
                        <th>Name Employee</th>
                        <th>Date</th>
                        <th>Time In</th>
                        <th>Time Out</th>

                        <th>Overtime</th>
                        <th>Late</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">
                    <!-- DataTables will populate this body -->
                </tbody>
            </table>
        </div>
        <!-- Status Modal -->
        <!-- Status Modal -->
        <div id="statusModal" class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden">
            <div class="bg-white rounded-lg shadow-lg w-96 p-4">
                <h3 id="statusTitle" class="text-lg font-bold mb-4">Status Updated</h3>
                <p id="statusMessage" class="text-gray-700 mb-4"></p>
                <div class="flex justify-end">
                    <button onclick="closeStatusModal()" class="px-4 py-2 bg-blue-500 text-white rounded-md">Close</button>
                </div>
            </div>
        </div>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i> <!-- Large lock icon indicating no access -->
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif


    <script>
        function changeStatus(id, status) {
            let action = status === 1 ? 'Approve' : 'Decline';
            $.ajax({
                url: '{{ route('attendance.updateStatus') }}', // Adjust the route accordingly
                type: 'POST',
                data: {
                    id: id,
                    status: status,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    if (response.success) {
                        // Update the modal content
                        const statusText = status === 1 ? 'Approved' : 'Declined';
                        document.getElementById('statusTitle').innerText = 'Status Updated';
                        document.getElementById('statusMessage').innerText =
                            `The status has been successfully updated to: ${statusText}`;
                        document.getElementById('statusModal').classList.remove('hidden');

                        // Reload the data table
                        $('#agencyTable').DataTable().ajax.reload(null,
                            false); // Reload data without resetting pagination
                    } else {
                        // Show error in modal
                        document.getElementById('statusTitle').innerText = 'Error';
                        document.getElementById('statusMessage').innerText = response.message;
                        document.getElementById('statusModal').classList.remove('hidden');
                    }
                },
                error: function(xhr) {
                    // Show generic error in modal
                    document.getElementById('statusTitle').innerText = 'Error';
                    document.getElementById('statusMessage').innerText =
                        'Something went wrong. Please try again.';
                    document.getElementById('statusModal').classList.remove('hidden');
                }
            });

        }

        function closeStatusModal() {
            // Hide the status modal
            document.getElementById('statusModal').classList.add('hidden');
        }
    </script>



    <script>
        $(document).ready(function() {
            $('#agencyTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('overtime.index') }}", // DataTable will fetch data from this route
                columns: [{
                        data: 'employee_id',
                        name: 'employee_id'
                    },
                    {
                        data: 'employee_name',
                        name: 'employee_name'
                    },
                    {
                        data: 'date',
                        name: 'date'
                    },
                    {
                        data: 'time_in',
                        name: 'time_in'
                    },
                    {
                        data: 'time_out',
                        name: 'time_out'
                    },
                    {
                        data: 'overtime', // Add the overtime column
                        name: 'overtime'
                    },
                    {
                        data: 'late', // Add the late column
                        name: 'late'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        width: '200px',
                        orderable: false,
                        searchable: false
                    }
                ],
                order: [
                    [3, 'desc']
                ] // Sort by the status column (6th column in this case) to prioritize null values first
            });
        });
    </script>


@endsection
