<div class="relative w-full bg-black bg-opacity-80">
    <div id="subscribe-form-modal"
        class="pd-overlay  hidden w-full h-full fixed top-0 left-0 z-[100]  overflow-x-hidden overflow-y-auto">
        <div
            class="w-full m-5 transition-all ease-out opacity-0 md:w-1/2 sm:mx-auto modal-open:opacity-100 modal-open:duration-500">
            <div class="flex flex-col px-5 py-4 bg-white rounded-2xl">
                <div class="flex items-center justify-between pb-4 border-b border-gray-200">
                    <h4 class="text-sm font-medium text-gray-900">Add Attendance</h4>
                    <button class="block cursor-pointer close-modal-button" data-pd-overlay="#subscribe-form-modal"
                        data-modal-target="subscribe-form-modal">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path d="M7.75732 7.75739L16.2426 16.2427M16.2426 7.75739L7.75732 16.2427" stroke="black"
                                stroke-width="1.6" stroke-linecap="round" />
                        </svg>
                    </button>
                </div>
                <div class="w-full p-8 mx-auto my-10 bg-white border border-gray-200 rounded-lg shadow-md">

                    <form action="{{ route('attendance.store') }}" method="POST">
                        @csrf
                        <div class="grid grid-cols-2 gap-4">
                            <div class="mt-4">
                                <label for="employee_id"
                                    class="block text-sm font-medium text-gray-700">Employee</label>
                                <select name="employee_id" id="employee_id"
                                    class="mt-1 block w-full border-2 border-black h-10 rounded-md shadow-sm @error('employee_id') border-red-500 @enderror"
                                    required>
                                    <option value="" disabled selected>Select an employee</option>
                                    @foreach ($employees as $employee)
                                        <option value="{{ $employee->id }}">{{ $employee->first_name }}
                                            {{ $employee->middle_name }} {{ $employee->last_name }}</option>
                                    @endforeach
                                </select>
                                @error('employee_id')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="mt-4">
                                <label for="date" class="block text-sm font-medium text-gray-700">Date</label>
                                <input type="date" name="date" id="date"
                                    class="mt-1 block w-full border-2 border-black h-10 rounded-md shadow-sm @error('date') border-red-500 @enderror"
                                    required>
                                @error('date')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="mt-4">
                                <label for="time_in" class="block text-sm font-medium text-gray-700">Time In</label>
                                <input type="time" name="time_in" id="time_in"
                                    class="mt-1 block w-full border-2 border-black h-10 rounded-md shadow-sm @error('time_in') border-red-500 @enderror"
                                    required>
                                @error('time_in')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="mt-4">
                                <label for="time_out" class="block text-sm font-medium text-gray-700">Time Out</label>
                                <input type="time" name="time_out" id="time_out"
                                    class="mt-1 block w-full border-2 border-black h-10 rounded-md shadow-sm @error('time_out') border-red-500 @enderror"
                                    required>
                                @error('time_out')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="mt-4">
                                <label for="notes" class="block text-sm font-medium text-gray-700">Notes</label>
                                <input type="text" name="notes" id="notes"
                                    class="mt-1 block w-full border-2 border-black h-10 rounded-md shadow-sm @error('notes') border-red-500 @enderror"
                                    maxlength="255">
                                @error('notes')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="flex justify-center ">
                            <button type="submit" class="px-4 py-2 mt-4 text-white bg-green-600 rounded-md">Create
                                Attendance</button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>




@foreach ($data as $data)
    <!-- Update Modal for each client -->
    <div id="updateModal{{ $data->id }}"
        class="fixed inset-0 z-50 flex items-start justify-center hidden bg-black bg-opacity-50 modal fade">
        <!-- Modal dialog -->
        <div class="w-1/2 mx-auto mt-10 overflow-hidden bg-white rounded-lg shadow-xl">
            <!-- Modal header -->
            <div class="flex items-center justify-between px-4 py-2 ">
                <h5 class="text-sm font-medium text-gray-900">Edit Attendance</h5>
                <button onclick="closeModal('updateModal{{ $data->id }}')" class="">&times;</button>
            </div>
            <div class="text-white modal-header bg-primary">
                <h5 class="modal-title" id="updateModalLabel{{ $data->id }}">Update Client Information</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="w-full p-8 mx-auto my-10 bg-white border border-gray-200 rounded-lg shadow-md">
                <!-- Update Form -->
                <form action="{{ route('attendance.update', $data->id) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="grid grid-cols-2 gap-4">

                        <div class="mt-4">
                            <label for="date" class="block text-sm font-medium text-gray-700">Date</label>
                            <input type="date" name="date" id="date"
                                class="mt-1 block w-full border-2 border-black h-10 rounded-md shadow-sm @error('date') border-red-500 @enderror"
                                required value="{{ $data->date }}">
                            @error('date')
                                <span class="text-sm text-red-500">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mt-4">
                            <label for="time_in" class="block text-sm font-medium text-gray-700">Time In</label>
                            <input type="time" name="time_in" id="time_in"
                                class="mt-1 block w-full border-2 border-black h-10 rounded-md shadow-sm @error('time_in') border-red-500 @enderror"
                                required value="{{ $data->time_in }}">
                            @error('time_in')
                                <span class="text-sm text-red-500">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mt-4">
                            <label for="time_out" class="block text-sm font-medium text-gray-700">Time Out</label>
                            <input type="time" name="time_out" id="time_out"
                                class="mt-1 block w-full border-2 border-black h-10 rounded-md shadow-sm @error('time_out') border-red-500 @enderror"
                                required value="{{ $data->time_out }}">
                            @error('time_out')
                                <span class="text-sm text-red-500">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mt-4">
                            <label for="notes" class="block text-sm font-medium text-gray-700">Notes</label>
                            <input type="text" name="notes" id="notes"
                                class="mt-1 block w-full border-2 border-black h-10 rounded-md shadow-sm @error('notes') border-red-500 @enderror"
                                maxlength="255" value="{{ $data->notes }}">
                            @error('notes')
                                <span class="text-sm text-red-500">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="flex justify-center ">
                        <button type="submit" class="px-4 py-2 mt-4 text-white bg-green-600 rounded-md">Create
                            Attendance</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div id="deleteModal{{ $data->id }}"
        class="fixed inset-0 z-50 flex items-start justify-center hidden bg-black bg-opacity-50 modal fade">
        <!-- Modal dialog -->
        <div class="max-w-md mx-auto mt-10 overflow-hidden bg-white rounded-lg shadow-xl">
            <!-- Modal header -->
            <div class="flex items-center justify-between px-4 py-2 bg-red-500">
                <h5 class="font-bold text-white">Confirm Delete</h5>
                <button onclick="closeModal('deleteModal{{ $data->id }}')" class="text-white">&times;</button>
            </div>

            <!-- Modal body -->
            <div class="px-4 py-4">
                <p>Are you sure you want to delete this data?</p>
            </div>

            <!-- Modal footer -->
            <div class="flex items-center justify-end px-4 py-3 bg-gray-100">
                <button onclick="closeModal('deleteModal{{ $data->id }}')"
                    class="px-3 py-1 mr-2 text-gray-800 bg-gray-300 rounded hover:bg-gray-400">Cancel</button>

                <!-- Form for delete -->
                <form id="deleteForm{{ $data->id }}" action="{{ route('attendance.destroy', $data->id) }}"
                    method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="submit"
                        class="px-3 py-1 text-white bg-red-500 rounded hover:bg-red-600">Delete</button>
                </form>
            </div>
        </div>
    </div>
@endforeach
<script>
    function openModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }

    // Function to close a modal
    function closeModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.add('hidden');
        modal.classList.remove('flex');
    }
</script>
