<script>
    var deleteRoute = "{{ route('ptsr.destroy', ':id') }}";
</script>


<!-- Delete Modal -->
<div id="deleteModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
    <div class="bg-white rounded-lg shadow-lg p-6 w-auto md:w-[30rem] mt-20">
        <h2 class="mb-4 text-lg font-bold">Delete Record</h2>
        <p>Are you sure you want to delete this record?</p>
        <form id="deleteForm">
            @csrf
            <input type="hidden" id="deleteRecordId" name="id">
            <div class="flex justify-end mt-6">
                <button type="button" onclick="closeModal('deleteModal')"
                    class="px-4 py-2 mr-2 text-gray-700 bg-gray-200 rounded">Cancel</button>
                <button type="submit" class="px-4 py-2 text-white bg-red-600 rounded">Delete</button>
            </div>
        </form>
    </div>
</div>



<div id="successModal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
    <div class="p-5 bg-white rounded-lg shadow-lg w-96">
        <h2 class="text-lg font-bold text-center">Success</h2>
        <p class="mt-2 text-center text-gray-700">Attendance record added successfully!</p>
        <div class="mt-4 text-center">
            <button id="closeSuccessModal" class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                OK
            </button>
        </div>
    </div>
</div>


<script>
    $(document).ready(function() {
        // Open Delete Modal
        window.openDeleteModal = function(recordId) {
            $('#deleteRecordId').val(recordId);
            $('#deleteModal').removeClass('hidden');
        };

        // Submit Delete Form
        $('#deleteForm').on('submit', function(e) {
            e.preventDefault();
            let recordId = $('#deleteRecordId').val();
            let deleteUrl = "{{ route('ptsr.destroy', ':id') }}".replace(':id', recordId);

            $.ajax({
                url: deleteUrl,
                type: "DELETE",
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    if (response.success) {
                        $('#successModal').removeClass('hidden'); // Show success modal
                        $('#deleteForm')[0].reset(); // Reset form
                        $('#deleteModal').addClass('hidden'); // Close modal
                        $('#agencyTable').DataTable().ajax.reload(null,
                            false); // Reload table without resetting pagination
                    }
                },
                error: function(xhr) {
                    alert('Error deleting record.');
                }
            });
        });

    });
</script>


<script>
    $(document).ready(function() {

        var currentStatus = "{{ request()->status }}";


        var table = $('#agencyTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('deduction', ['status' => ':status']) }}".replace(':status', currentStatus),
            order: [
                [2, 'desc']
            ],
            columns: [{
                    data: function(row) {
                        return row.employee.first_name + ' ' +
                            (row.employee.middle_name ? row.employee.middle_name + ' ' : '') +
                            row.employee.last_name;
                    },
                    name: 'employee.first_name'
                },
                {
                    data: 'department',
                    name: 'department'
                },
                {
                    data: 's_date',
                    name: 's_date'
                },
                {
                    data: 'e_date',
                    name: 'e_date'
                },

                {
                    data: 'status',
                    name: 'status'
                },
                {
                    data: 'action',
                    name: 'action'
                }
            ]
        });

        // AJAX Form Submission
        $('#ptsrImportForm').on('submit', function(e) {
            e.preventDefault();
            let formData = new FormData(this);
            var errorContainer = document.getElementById("error-container");
            var loadingOverlay = document.getElementById("loading-overlay");

            // Show the loading spinner and disable the form
            loadingOverlay.style.display = "flex";
            $.ajax({
                url: "{{ route('importdeduction') }}",
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,
                beforeSend: function() {
                    $("#successMessage, #errorMessage").addClass('hidden').text('');
                },
                success: function(response) {
                    if (response.success) {
                        $('#successModal').removeClass('hidden');
                        table.ajax.reload(null, false); // Reload DataTable
                        // $('#ptsrImportForm')[0].reset();

                        // Show failed rows in modal if any exist
                        if (response.failedRows.length > 0) {
                            showFailedRows(response.failedRows);
                        }

                    } else {
                        $("#errorMessage").removeClass('hidden').text(response.message);

                    }
                    loadingOverlay.style.display = "none";
                },
                error: function(xhr) {
                    $("#errorMessage").removeClass('hidden').text("Error importing file.");
                    if (xhr.responseJSON.errors) {
                        let errors = xhr.responseJSON.errors;
                        $("#fileError").text(errors.file ? errors.file[0] : "");
                        $("#startDateError").text(errors.start_date ? errors.start_date[0] :
                            "");
                        $("#endDateError").text(errors.end_date ? errors.end_date[0] : "");
                    }
                    loadingOverlay.style.display = "none";
                }
            });
        });

        function closeModal(modalId, reopenButtonId) {
            $(modalId).addClass('hidden');
            $('#' + reopenButtonId).removeClass('hidden');
        }

        // Function to reopen modal & hide reopen button
        function reopenModal(modalId, reopenButtonId) {
            $('#' + modalId).removeClass('hidden');
            $('#' + reopenButtonId).addClass('hidden');
        }

        function showFailedRows(failedRows) {
            let tableBody = $("#failedRowsBody");
            let tableHead = $("#failedRowsModal thead tr");

            tableBody.empty(); // Clear previous data

            // Get already displayed headers
            let existingHeaders = new Set();
            tableHead.find("th").each(function() {
                existingHeaders.add($(this).text().trim().toLowerCase());
            });

            let additionalHeaders = new Set();

            // Identify truly new headers (not yet displayed)
            failedRows.forEach(row => {
                Object.keys(row.row_data).forEach(header => {
                    if (!existingHeaders.has(header.toLowerCase())) {
                        additionalHeaders.add(header);
                    }
                });
            });

            // Append only missing headers
            additionalHeaders.forEach(header => {
                tableHead.append(`<th class="px-3 border-2 border-black">${header}</th>`);
                existingHeaders.add(header.toLowerCase()); // Mark as displayed
            });

            // Populate the table rows
            failedRows.forEach(row => {
                let rowData = row.row_data || {};
                let trxCodes = row.trx_codes.length ? row.trx_codes.map(tc =>
                    `${tc.header}: ${tc.message}`).join("<br>") : "Employee Not Found";

                let formattedRow = `<td class="px-3 border-2 border-black">${trxCodes}</td>`;

                additionalHeaders.forEach(header => {
                    formattedRow +=
                        `<td class="px-3 border-2 border-black">${rowData[header] || "0"}</td>`;
                });

                tableBody.append(`<tr class="border-b">${formattedRow}</tr>`);
            });

            // Show modal & hide reopen button
            $("#failedRowsModal").removeClass("hidden");

        }


        // Function to print the failed rows table
        function printTable(modalId) {
            const modal = document.querySelector(modalId);
            if (!modal) return alert('Modal not found');

            const printContent = modal.querySelector('table').outerHTML;

            const printWindow = window.open('', '', 'height=800,width=800');
            printWindow.document.write(`
<html>
<head>
    <title>Failed Rows Report</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; font-size: 10px; }
        th, td { padding: 8px; text-align: left; border-bottom: 1px solid #ddd; }
        th { background-color: #f2f2f2; color: #333; }
        td { color: #555; }
        tr:hover { background-color: #f9f9f9; }
        .error-cell { color: red; font-weight: bold; }
    </style>
</head>
<body>
    <h2>Failed Rows Report</h2>
    ${printContent}
</body>
</html>
`);
            printWindow.document.close();
            printWindow.print();
        }

        // Attach event listeners
        $('#printFailedRowsModal').click(function() {
            printTable('#failedRowsModal');
        });

        $('#closeFailedRowsModal').click(function() {
            closeModal('#failedRowsModal', 'reopenFailedRowsModal');
        });

        $('#closeSuccessModal').click(function() {
            closeModal('#successModal', 'reopenSuccessModal');
        });

        // Attach event listeners for reopen buttons
        $('#reopenFailedRowsModal').click(function() {
            reopenModal('failedRowsModal', 'reopenFailedRowsModal'); // No `#` in the argument
        });




        window.closeModal = function(modalId) {
            $('#' + modalId).addClass('hidden');
        };
    });
</script>

<div id="adjustmentModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
    <div class="bg-white rounded-lg p-6 mt-20 h-[50rem] md:h-auto w-[70rem] overflow-auto">
        <div id="loading-overlay" class="flex items-center justify-center hidden mt-4 mb-4">
            <div
                class="inline-block w-12 h-12 border-4 border-blue-600 rounded-full spinner-border animate-spin border-t-transparent">
            </div>
            <p class="ml-3 text-gray-700">Processing...</p>
        </div>
        <div>
            <select id="optionSelector" class="w-full p-2 border rounded-md focus:ring focus:ring-blue-300">
                <option value="">-- Select --</option>
                <option value="div1">Import Ptsr</option>
                <option value="div2">Manual Input</option>

            </select>
        </div>
        <div id="div1" class="p-4 mt-4 ">
            <form id="ptsrImportForm" action="{{ route('importdeduction') }}" method="POST"
                enctype="multipart/form-data" class="p-6 mx-auto">
                @csrf
                @if (request()->routeIs('deduction'))
                    <h2 class="mb-6 text-2xl font-semibold text-center">Import Deduction Data</h2>
                @else
                    <h2 class="mb-6 text-2xl font-semibold text-center">Import Earnings Data</h2>
                @endif

                <div class="grid grid-cols-1 gap-6 text-xs sm:grid-cols-2 md:grid-cols-2">
                    <div class="mb-4">
                        <label for="department_id" class="text-sm font-medium text-gray-700">Choose Department</label>
                        <select name="department_id" id="departmentimport"
                            class="w-full p-2 border-2 border-black rounded-md" required>
                            <option value="" disabled selected>Select Department</option>
                            @foreach ($client as $department)
                                <option value="{{ $department->id }}">{{ $department->department_name }}</option>
                            @endforeach
                        </select>

                    </div>
                    <script>
                        $(document).ready(function() {
                            $('#departmentimport').select2({
                                placeholder: "Select an Employee",
                                allowClear: true,
                                width: '100%'
                            });

                        });
                    </script>
                    <div class="flex flex-col">
                        <label for="file" class="text-sm font-medium text-gray-700">Upload File</label>
                        <input type="file" name="file" id="file" required
                            class="w-full p-2 border-2 border-black rounded-md">
                        <span id="fileError" class="text-sm text-red-600"></span>
                    </div>

                    <!-- Start Date -->
                    <div class="flex flex-col">
                        <label for="start_date" class="text-sm font-medium text-gray-700">Start Date</label>
                        <input type="date" name="start_date" id="start_date" required
                            class="w-full p-2 border-2 border-black rounded-md">
                        <span id="startDateError" class="text-sm text-red-600"></span>
                    </div>

                    <!-- End Date -->
                    <div class="flex flex-col">
                        <label for="end_date" class="text-sm font-medium text-gray-700">End Date</label>
                        <input type="date" name="end_date" id="end_date" required
                            class="w-full p-2 border-2 border-black rounded-md">
                        <span id="endDateError" class="text-sm text-red-600"></span>
                    </div>
                </div>
                @if (request()->routeIs('deduction'))
                    <input type="hidden" name="status" id="status" value="deduction" required
                        class="w-full p-2 border-2 border-black rounded-md">
                @else
                    <input type="hidden" name="status" id="status" value="earning" required
                        class="w-full p-2 border-2 border-black rounded-md">
                @endif
                <!-- Submit Button -->
                <div class="flex justify-end gap-4 py-5 text-sm ">
                    <button type="submit"
                        class="w-full px-6 py-2 text-white bg-blue-600 rounded-md hover:bg-blue-700 focus:ring-2 focus:ring-blue-500 focus:ring-opacity-50 sm:w-auto">
                        Import
                    </button>
                    <button type="button" onclick="closeModal('adjustmentModal')"
                        class="w-full px-4 py-2 text-white bg-red-500 rounded-md hover:bg-red-600 sm:w-auto">
                        Close
                    </button>
                </div>

            </form>

        </div>

        <div id="div2" class="hidden p-4 mt-4 ">
            <div id="messageContainer" class="hidden p-3 text-center rounded-md"></div>
            <form id="ptsrForm" enctype="multipart/form-data" class="p-6 mx-auto">
                @csrf
                @if (request()->routeIs('deduction'))
                    <h2 class="mb-6 text-2xl font-semibold text-center">Deduction Manual Input</h2>
                @else
                    <h2 class="mb-6 text-2xl font-semibold text-center">Earnings Manual Input</h2>
                @endif
                <div class="grid grid-cols-1 gap-4 text-xs sm:grid-cols-2 md:grid-cols-3">
                    <!-- Employee -->
                    <div class="mb-3">
                        <label class="block text-gray-700">Employee</label>
                        <select name="employee_id" id="employeeSelect" required
                            class="w-full p-1 text-xs border border-black rounded-md">
                            <option value="" selected disabled>Select Employee</option>
                            @foreach ($employees as $employee)
                                <option value="{{ $employee->id }}">{{ $employee->first_name }}
                                    {{ $employee->last_name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Department -->
                    <div class="mb-3">
                        <label class="block text-gray-700">Choose Department</label>
                        <select name="department_id" id="departmentSelect" required
                            class="w-full p-1 text-xs border border-black rounded-md">
                            <option value="" selected disabled>Select Department</option>
                        </select>
                    </div>

                    <!-- Start Date -->
                    <div class="mb-3">
                        <label class="block text-gray-700">Start Date</label>
                        <input type="date" name="start_date" id="start_date" required
                            class="w-full p-1 text-xs border border-black rounded-md">
                    </div>

                    <!-- End Date -->
                    <div class="mb-3">
                        <label class="block text-gray-700">End Date</label>
                        <input type="date" name="end_date" id="end_date" required
                            class="w-full p-1 text-xs border border-black rounded-md">
                    </div>

                 @if (request()->routeIs('deduction'))
                    <input type="hidden" name="status" id="status" value="deduction" required
                        class="w-full p-2 border-2 border-black rounded-md">
                @else
                    <input type="hidden" name="status" id="status" value="earning" required
                        class="w-full p-2 border-2 border-black rounded-md">
                @endif
                </div>

                <!-- Transaction Fields -->
                <div
                    class="grid grid-cols-1 gap-3 p-3 mt-4 text-xs bg-gray-100 border rounded-md shadow sm:grid-cols-2">
                    <div>
                        <label class="block text-gray-700">Transaction Code</label>
                        <select name="trx_codes[]"
                            class="w-full p-1 text-xs border border-black rounded-md trxcode-select">
                            @foreach ($trxCodes as $code)
                                <option value="{{ $code->id }}">{{ $code->description }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label class="block text-gray-700">Amount</label>
                        <input type="number" name="amounts[]" step="0.01"
                            class="w-full p-1 text-xs border border-black rounded-md">
                    </div>
                </div>

                <!-- Dynamic Transactions -->
                <div id="transactionsContainer"></div>

                <!-- Add Transaction Button -->
                <div class="mt-3">
                    <button type="button" id="addTransaction"
                        class="px-3 py-1 text-xs text-white bg-green-500 rounded-md">
                        Add Transaction
                    </button>
                </div>

                <!-- JavaScript -->
                <script>
                    $(document).ready(function() {
                        // Apply select2 to dropdowns


                        $('.trxcode-select').select2({
                            placeholder: "Select a Transaction Code",
                            allowClear: true,
                            width: '100%'
                        });

                        // Add transaction dynamically
                        $("#addTransaction").on("click", function() {
                            const container = $("#transactionsContainer");
                            const newRow = `
                                <div class="grid grid-cols-1 gap-3 p-3 mb-3 text-xs border rounded-md shadow-sm sm:grid-cols-2 bg-gray-50">
                                    <select name="trx_codes[]" class="w-full p-1 text-xs border border-black rounded-md trxcode-select" >
                                        @foreach ($trxCodes as $code)
                                            <option value="{{ $code->id }}">{{ $code->description }}</option>
                                        @endforeach
                                    </select>
                                    <input type="number" name="amounts[]" step="0.01"  class="w-full p-1 text-xs border border-black rounded-md">
                                    <button type="button" class="px-3 py-1 text-xs text-white bg-red-500 rounded-md removeTransaction">Remove</button>
                                </div>`;
                            container.append(newRow);

                            // Apply select2 to newly added dropdowns
                            container.find('.trxcode-select').last().select2({
                                placeholder: "Select a Transaction Code",
                                allowClear: true,
                                width: '100%'
                            });
                        });

                        // Remove transaction row
                        $(document).on("click", ".removeTransaction", function() {
                            $(this).closest("div.grid").remove();
                        });

                    });
                </script>
                <script>
                    $(document).ready(function() {
                        // Initialize select2 for dropdowns
                        $('#employeeSelect, #departmentSelect').select2({
                            placeholder: "Select an option",
                            allowClear: true,
                            width: '100%'
                        });

                        // Handle employee selection change
                        $('#employeeSelect').change(function() {
                            let employeeId = $(this).val(); // Get selected employee's ID

                            if (employeeId) {

                                $.ajax({
                                    url: "{{ route('clients.by.employee') }}", // The route we defined in web.php
                                    type: 'GET',
                                    data: {
                                        employee_id: employeeId // Pass the employee ID
                                    },
                                    success: function(response) {
                                        let clientSelect = $('#departmentSelect');
                                        clientSelect.empty(); // Clear the existing options
                                        clientSelect.append(
                                            '<option value="">Select Client</option>'); // Default option

                                        // Add the clients to the dropdown
                                        response.forEach(function(client) {
                                            clientSelect.append('<option value = "' + client.id +
                                                '">' + client.name + '</option>'
                                            ); // Assuming 'name' is the client property
                                        });

                                        clientSelect.trigger('change'); // Reinitialize select2 after update
                                    },
                                    error: function(xhr, status, error) {
                                        console.error('Error fetching clients:', error);
                                    }
                                });




                            }
                        });
                    });
                </script>


                <div class="flex justify-end gap-4 py-5 text-sm">

                    <button type="submit"
                        class="w-full px-6 py-2 text-white bg-blue-600 rounded-md hover:bg-blue-700 sm:w-auto">
                        Add
                    </button>
                    <button type="button" onclick="closeModal('adjustmentModal')"
                        class="w-full px-4 py-2 text-white bg-red-500 rounded-md hover:bg-red-600 sm:w-auto">
                        Close
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    function openModal(id) {
        document.getElementById(id).classList.remove('hidden');
    }

    // Function to close the modal dynamically based on ID
    function closeModal(id) {
        document.getElementById(id).classList.add('hidden');
    }
</script>
<script>
    document.getElementById("optionSelector").addEventListener("change", function() {
        let selectedValue = this.value;

        // Hide all divs
        document.querySelectorAll("[id^=div]").forEach(div => {
            div.classList.add("hidden");
        });

        // Show selected div
        if (selectedValue) {
            document.getElementById(selectedValue).classList.remove("hidden");
        }
    });
</script>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        const form = document.getElementById("ptsrForm");
        const messageDiv = document.getElementById("messageContainer");

        form.addEventListener("submit", async function(event) {
            event.preventDefault();

            const formData = new FormData(form);
            messageDiv.classList.add("hidden");

            try {
                const response = await fetch("{{ route('ptsr.store') }}", {
                    method: "POST",
                    body: formData,
                    headers: {
                        "X-Requested-With": "XMLHttpRequest"
                    },
                });

                const data = await response.json();

                if (response.ok) {
                    showMessage("✅ " + data.message, "bg-green-500 text-white");
                    // form.reset();

                    // Check if DataTable exists before reloading
                    const table = document.getElementById("agencyTable");
                    if (table && $.fn.DataTable) {
                        $("#agencyTable").DataTable().ajax.reload(null, false);
                    }
                } else {
                    showMessage("❌ " + (data.message || "Something went wrong"),
                        "bg-red-500 text-white");
                }
            } catch (error) {
                console.error("Error:", error);
                showMessage("❌ Failed to submit the form!", "bg-red-500 text-white");
            }
        });

        function showMessage(text, classes) {
            messageDiv.textContent = text;
            messageDiv.className = `p-3 rounded-md text-center ${classes}`;
            messageDiv.classList.remove("hidden");

            setTimeout(() => {
                messageDiv.classList.add("hidden");
            }, 5000);
        }
    });
</script>
