<!DOCTYPE html>
<html>

<head>
    <title>Failed Rows</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }
    </style>
</head>

<body>
    <h2>Failed Rows</h2>
    <table>
        <thead>
            <tr>
                <th>Line #</th>
                <th>EnNo</th>
                <th>IN/OUT</th>
                <th>DateTime</th>
                <th>Error</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($failedRows as $row)
                <tr>
                    <td>{{ $row['line'] ?? 'N/A' }}</td>
                    <td>{{ $row['EnNo'] ?? 'N/A' }}</td>
                    <td>{{ $row['IN/OUT'] ?? 'N/A' }}</td>
                    <td>{{ $row['DateTime'] ?? 'N/A' }}</td>
                    <td>{{ $row['error'] ?? 'Invalid DateTime or Missing Data' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>
