@include('Admin.Attendance.complete.attendance_2')



<div id="successModal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
    <div class="p-5 bg-white rounded-lg shadow-lg w-96">
        <h2 class="text-lg font-bold text-center">Success</h2>
        <p class="mt-2 text-center text-gray-700">Attendance record added successfully!</p>
        <div class="mt-4 text-center">
            <button id="closeSuccessModal" class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                OK
            </button>
        </div>
    </div>
</div>


<script>
    $(document).ready(function() {
        // Initialize DataTable
        var table = $('#agencyTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('attendance.index') }}",
            columns: [{
                    data: 'employee_id',
                    name: 'employee_id'
                },
                {
                    data: 'client_name',
                    name: 'client_name'
                },
                {

                    data: 'employee_name',
                    name: 'employee_name'

                },
                {
                    data: 'date',
                    name: 'date'
                },
                {
                    data: 'time_in',
                    name: 'time_in'
                },
                {
                    data: 'break_out',
                    name: 'break_out'
                },
                {
                    data: 'break_in',
                    name: 'break_in'
                },
                {
                    data: 'time_out',
                    name: 'time_out'
                },
                {
                    data: 'notes',
                    name: 'notes'
                },
                {
                    data: 'status',
                    name: 'status'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ]
        });

        // Attach event listeners to each form separately
        $('#formImport2').submit(function(event) {
            event.preventDefault();
            handleFormSubmission($(this), '#failedRowsTable', '#failedRowsModal');
        });

        $('#formImport3').submit(function(event) {
            event.preventDefault();
            handleFormSubmission($(this), '#failedRowsTable1', '#failedRowsModal1');
        });


        // Function to handle form submission dynamically
        function handleFormSubmission(form, tableSelector, modalSelector) {
            var formData = new FormData(form[0]);
            var formAction = form.attr('action');


            $('#importButton').prop('disabled', true).addClass('opacity-50 cursor-not-allowed');
            $('#buttonText').text('Importing...');
            $('#loadingIndicator').removeClass('hidden');
            $.ajax({
                url: formAction,
                method: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    $('#importButton').prop('disabled', false).removeClass(
                        'opacity-50 cursor-not-allowed');
                    $('#buttonText').text('Import');
                    $('#loadingIndicator').addClass('hidden');
                    if (response.success) {
                        $('#successModal').removeClass('hidden'); // Show success modal
                        form[0].reset();
                        table.ajax.reload(null, false); // Reload table without resetting pagination
                        $('#employeefordtrTable').DataTable().ajax.reload(null,
                            false);
                    }

                    if (response.failedRows && modalSelector === '#failedRowsModal') {
                        populateFailedRows(response.failedRows, tableSelector, modalSelector);
                    } else if (response.failedRows1 && modalSelector === '#failedRowsModal1') {
                        populateFailedRows1(response.failedRows1, tableSelector, modalSelector);
                    }
                },
                error: function(xhr) {
                    alert('Error: ' + xhr.responseText);
                }
            });
        }

        // Function to populate failed rows dynamically (Import Option 1)
        function populateFailedRows1(failedRows, tableSelector, modalSelector) {
            var tableBody = $(tableSelector);
            tableBody.empty();

            failedRows.forEach(function(row) {
                tableBody.append(`
            <tr class="hover:bg-gray-50">
                <td  class="px-3 border-2 border-black">${row.line ?? 'N/A'}</td>
                <td class="px-3 border-2 border-black">${row.ID ?? 'N/A'}</td>
                <td  class="px-3 border-2 border-black">${row['Column 2'] ?? 'N/A'}</td>
                <td class="px-3 border-2 border-black">${row.DateTime ?? 'N/A'}</td>
                <td class="px-3 text-red-500 border-2 border-black">${row.error ?? 'Unknown Error'}</td>
            </tr>
        `);
            });

            $(modalSelector).removeClass('hidden'); // Show the modal
        }


        // Function to populate failed rows dynamically (Import Option 2)
        function populateFailedRows(failedRows, tableSelector, modalSelector) {
            var tableBody = $(tableSelector);
            tableBody.empty();

            failedRows.forEach(function(row) {
                tableBody.append(`
            <tr class="hover:bg-gray-50">
                <td class="px-3 border-2 border-black">${row.line ?? 'N/A'}</td>
                <td class="px-3 border-2 border-black">${row.EnNo ?? 'N/A'}</td>
                <td class="px-3 border-2 border-black">${row['IN/OUT'] ?? 'N/A'}</td>
               <td class="px-3 border-2 border-black">
  ${row.DateTime ? new Date(row.DateTime).toLocaleString('en-US', {
    month: 'long',    // June
    day: 'numeric',   // 3
    year: 'numeric',  // 2025
    hour: 'numeric',  // 4
    minute: '2-digit',// 30
    hour12: true      // PM format
  }) : 'N/A'}
</td>
                <td class="px-3 text-red-500 border-2 border-black">${row.error ?? 'Unknown Error'}</td>
            </tr>
        `);
            });

            $(modalSelector).removeClass('hidden'); // Show the modal
        }


        function closeModal(modalId, reopenButtonId) {
            $(modalId).addClass('hidden');
            $('#' + reopenButtonId).removeClass('hidden'); // Show the reopen button
        }

        // Function to reopen modals
        function reopenModal(modalId, reopenButtonId) {
            $('#' + modalId).removeClass('hidden');
            $('#' + reopenButtonId).addClass('hidden'); // Hide the reopen button
        }

        // Function to print failed rows
        function printFailedRows(modalSelector) {
            const modal = document.querySelector(modalSelector);
            if (!modal) return alert('Modal not found');

            const printContent = modal.querySelector('.modal-body').innerHTML;
            const printWindow = window.open('', '', 'height=800,width=800');

            printWindow.document.write('<html><head><title>Failed Rows</title><style>');
            printWindow.document.write(`
            body {
                font-family: Arial, sans-serif;
                margin: 20px;
            }
            table {
                width: 100%;
                border-collapse: collapse;
                margin-top: 20px;
                font-size: 14px;
            }
            th, td {
                padding: 8px;
                text-align: left;
                border-bottom: 1px solid #ddd;
            }
            th {
                background-color: #f2f2f2;
                color: #333;
            }
            td {
                color: #555;
            }
            tr:hover {
                background-color: #f9f9f9;
            }
            .error-cell {
                color: red;
                font-weight: bold;
            }
        `);
            printWindow.document.write('</style></head><body>');
            printWindow.document.write('<h2>Failed Rows Report</h2>');
            printWindow.document.write(printContent);
            printWindow.document.write('</body></html>');
            printWindow.document.close();
            printWindow.print();
        }

        // Assign click handlers for closing modals
        $('#closeFailedRowsModal').click(function() {
            closeModal('#failedRowsModal', 'reopenFailedRowsModal');
        });

        $('#closeFailedRowsModal1').click(function() {
            closeModal('#failedRowsModal1', 'reopenFailedRowsModal1');
        });

        $('#closeSuccessModal').click(function() {
            closeModal('#successModal');
        });

        // Assign click handlers for printing
        $('#printFailedRowsModal').click(function() {
            printFailedRows('#failedRowsModal');
        });

        $('#printFailedRowsModal1').click(function() {
            printFailedRows('#failedRowsModal1');
        });

        // Assign click handlers for reopening modals
        $('#reopenFailedRowsModal').click(function() {
            reopenModal('failedRowsModal', 'reopenFailedRowsModal');
        });

        $('#reopenFailedRowsModal1').click(function() {
            reopenModal('failedRowsModal1', 'reopenFailedRowsModal1');
        });

        // Auto-show modals if failedRows exist in session
        @if (session('failedRows'))
            $('#failedRowsModal').removeClass('hidden');
            $('#reopenFailedRowsModal').removeClass('hidden'); // Show reopen button
        @endif

        @if (session('failedRows1'))
            $('#failedRowsModal1').removeClass('hidden');
            $('#reopenFailedRowsModal1').removeClass('hidden'); // Show reopen button
        @endif

        window.closeModal = function(modalId) {
            $('#' + modalId).addClass('hidden');
        };
    });
</script>

<script>
    $(document).on('change', '.status-checkbox', function() {
        let checkbox = $(this);
        let attendanceId = checkbox.data('id');
        let newStatus = checkbox.is(':checked') ? 1 : null;

        $.ajax({
            url: "{{ route('attendance.update-status', ':id') }}".replace(':id', attendanceId),
            type: "POST",
            data: {
                status: newStatus,
                _token: "{{ csrf_token() }}"
            },
            success: function(response) {

                $('#agencyTable').DataTable().ajax.reload(null,
                    false); // Reload table without resetting pagination
            },
            error: function(error) {
                console.log(error);
            }
        });
    });
</script>

<script>
    $(document).ready(function() {
        $('#updateStatusBtn').click(function() {
            let startDate = $('#start_date').val();
            let endDate = $('#end_date').val();

            if (!startDate || !endDate) {
                alert("Please select a date range.");
                return;
            }

            $.ajax({
                url: "{{ route('attendance.update-status-range') }}",
                type: "POST",
                data: {
                    start_date: startDate,
                    end_date: endDate,
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    alert(response.message);
                    $('#agencyTable').DataTable().ajax.reload(null,
                        false);
                },
                error: function(xhr) {
                    console.log(xhr.responseText);
                }
            });
        });
    });
</script>


<script>
    $(document).ready(function() {
        // Open Delete Modal
        window.openDeleteModal = function(recordId) {
            $('#deleteRecordId').val(recordId);
            $('#deleteModal').removeClass('hidden');
        };

        // Submit Delete Form
        $('#deleteForm').on('submit', function(e) {
            e.preventDefault();
            let recordId = $('#deleteRecordId').val();
            let deleteUrl = "{{ route('attendance.destroy', ':id') }}".replace(':id', recordId);

            $.ajax({
                url: deleteUrl,
                type: "DELETE",
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    if (response.success) {
                        $('#successModal').removeClass('hidden'); // Show success modal
                        $('#deleteForm')[0].reset(); // Reset form
                        $('#deleteModal').addClass('hidden'); // Close modal
                        $('#agencyTable').DataTable().ajax.reload(null,
                            false); // Reload table without resetting pagination
                    }
                },
                error: function(xhr) {
                    alert('Error deleting record.');
                }
            });
        });

        // Close Modal Function
        window.closeModal = function(modalId) {
            $('#' + modalId).addClass('hidden');
        };
    });
</script>
<script>
    $(document).ready(function() {
        // Function to open the edit modal
        window.openEditModal = function(recordId) {
            let editUrl = "{{ route('attendance.edit', ':id') }}".replace(':id', recordId);

            $.get(editUrl, function(data) {
                $('#editRecordId').val(data.id);
                $('#editEmployeeId').val(data.employee_id);
                $('#editDepartmentId').val(data.department_id);
                $('#editDate').val(data.date);
                $('#editTimeIn').val(data.time_in);
                $('#editTimeOut').val(data.time_out);
                $('#editNotes').val(data.notes);

                $('#editModal').removeClass('hidden'); // Show modal
            }).fail(function() {
                alert('Error fetching record.');
            });
        };

        // Submit Edit Form
        $('#editForm').on('submit', function(e) {
            e.preventDefault();

            let timeIn = $('#editTimeIn').val();
            let timeOut = $('#editTimeOut').val();

            // Ensure only HH:MM is submitted (remove :SS if present)
            timeIn = timeIn.substring(0, 5);
            timeOut = timeOut.substring(0, 5);

            $('#editTimeIn').val(timeIn);
            $('#editTimeOut').val(timeOut);

            let recordId = $('#editRecordId').val();
            let updateUrl = "{{ route('attendance.update', ':id') }}".replace(':id', recordId);
            let formData = $(this).serialize();

            $.ajax({
                url: updateUrl,
                type: "PUT",
                data: formData,
                success: function(response) {
                    if (response.success) {
                        $('#successModal').removeClass('hidden');

                        closeModal('editModal');
                        $('#agencyTable').DataTable().ajax.reload(null, false);
                    }
                },
                error: function(xhr) {
                    alert('Error updating record.');
                }
            });
        });



        // Function to close modals
        window.closeModal = function(modalId) {
            $('#' + modalId).addClass('hidden');
        };
    });
</script>
