@extends('layouts.sidebar')
@section('title', 'Attendance')
@section('content')
    @if (in_array('Manage Attendance', $privileges))

        @include('Admin.Attendance.complete.modal')
        <div class="flex flex-col justify-between py-5 md:flex-row">
            <h1 class="mb-4 font-bold">Attendace</h1>
            <div class="mb-6">
                <form action="{{ route('attendance.pdf') }}" method="GET"
                    class="space-y-4 md:space-y-0 md:flex md:items-end md:gap-4 flex-wrap">

                    <!-- Department Filter -->
                    <div class="flex flex-col">
                        <label for="department_id" class="mb-1 font-semibold text-gray-700">Department</label>
                        <select name="department_id" id="department_id" required
                            class="border border-gray-300 rounded-md p-2 focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Select Department</option>
                            @foreach ($client as $dept)
                                <option value="{{ $dept->id }}"
                                    {{ request('department_id') == $dept->id ? 'selected' : '' }}>
                                    {{ $dept->department_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Employee Filter (Optional) -->
                    <div class="flex flex-col">
                        <label for="employee_id" class="mb-1 font-semibold text-gray-700">Employee</label>
                        <select name="employee_id" id="employee_id"
                            class="border border-gray-300 rounded-md p-2 focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">All Employees</option>
                            @foreach ($employees as $emp)
                                <option value="{{ $emp->id }}"
                                    {{ request('employee_id') == $emp->id ? 'selected' : '' }}>
                                    {{ $emp->last_name }}, {{ $emp->first_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Start Date -->
                    <div class="flex flex-col">
                        <label for="startDate" class="mb-1 font-semibold text-gray-700">Start Date</label>
                        <input type="date" name="startDate" id="startDate" value="{{ request('startDate') }}"
                            class="border border-gray-300 rounded-md p-2 focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>

                    <!-- End Date -->
                    <div class="flex flex-col">
                        <label for="endDate" class="mb-1 font-semibold text-gray-700">End Date</label>
                        <input type="date" name="endDate" id="endDate" value="{{ request('endDate') }}"
                            class="border border-gray-300 rounded-md p-2 focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>

                    <!-- Export Button -->
                    <div>
                        <button type="submit"
                            class="bg-blue-600 text-white font-semibold px-4 py-2 rounded-md hover:bg-blue-700 transition">
                            Export PDF / ZIP
                        </button>
                    </div>

                </form>
            </div>


            <div class="flex items-center justify-center gap-5">
                <button id="reopenFailedRowsModal" class="hidden px-4 py-2 text-white bg-red-500 rounded">Reopen Failed Rows
                    Option 2</button>
                <button id="reopenFailedRowsModal1" class="hidden px-4 py-2 text-white bg-red-500 rounded">Reopen Failed
                    Rows
                    Option 3</button>
                <button type="button"
                    class="modal-button w-40 h-10 bg-[#1d1d1d] text-white rounded-md text-xs cursor-pointer font-semibold text-center shadow-xs transition-all duration-500 hover:bg-indigo-700"
                    onclick="openModal('attendanceModal')">
                    Add Attendance
                </button>
            </div>
        </div>
        @if (session('success'))
            <div class="p-4 mb-4 text-white bg-green-500">
                {{ session('success') }}
            </div>
        @endif

        @if (session('warning'))
            <div class="p-4 mb-4 text-white bg-green-500">
                {{ session('warning') }}
            </div>
        @endif
        {{-- <div class="grid gap-5 mb-2 text-sm lg:grid-cols-3 crid-cols-1">


            @include('Admin.Attendance.complete.formmodal')

        </div> --}}


        <script>
            document.addEventListener("DOMContentLoaded", function() {
                const firstDiv = document.getElementById("firstDiv");
                const secondDiv = document.getElementById("secondDiv");
                const showSecond = document.getElementById("showSecond");
                const showFirst = document.getElementById("showFirst");

                showSecond.addEventListener("click", function() {
                    firstDiv.classList.add("hidden");
                    secondDiv.classList.remove("hidden");
                });

                showFirst.addEventListener("click", function() {
                    secondDiv.classList.add("hidden");
                    firstDiv.classList.remove("hidden");
                });
            });
        </script>


        @include('Admin.Attendance.complete.table')
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i> <!-- Large lock icon indicating no access -->
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif

    @include('Admin.Attendance.complete.js')
@endsection
