<!-- Failed Rows Modal -->
<div id="failedRowsModal1" class="fixed inset-0 z-50 hidden overflow-y-auto bg-gray-900 bg-opacity-50">
    <div class="relative w-3/4 max-w-4xl mx-auto mt-20 bg-white rounded-lg shadow-lg">
        <div class="p-4 border-b">
            <h2 class="text-lg font-bold">Failed Attendance Records</h2>

        </div>
        <div class="flex justify-end gap-4 p-4 border-t">

            <button id="closeFailedRowsModal1" onclick="closeModal('#failedRowsModal1')"
                class="px-4 py-2 text-white bg-red-500 rounded">Close</button>
            <button id="printFailedRowsModal1" onclick="printFailedRows('#failedRowsModal1')"
                class="px-4 py-2 text-white bg-blue-500 rounded">Print</button>



        </div>
        <div class="p-4 overflow-auto text-sm modal-body">
            <table class="w-full text-sm border border-collapse border-gray-300 text-nowrap">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="px-3 border-2 border-black">Line</th>
                        <th class="px-3 border-2 border-black">ID</th>
                        <th class="px-3 border-2 border-black">Column 2</th>
                        <th class="px-3 border-2 border-black">DateTime</th>
                        <th class="px-3 border-2 border-black">Error</th>
                    </tr>
                </thead>
                <tbody id="failedRowsTable1">
                    <!-- Failed rows will be appended here -->
                </tbody>
            </table>
        </div>

    </div>
</div>

<!-- Failed Rows Modal for Import Option 2 -->
<div id="failedRowsModal" class="fixed inset-0 z-50 hidden overflow-y-auto bg-gray-900 bg-opacity-50">
    <div class="relative w-3/4 max-w-5xl mx-auto mt-20 bg-white rounded-lg shadow-lg">
        <div class="p-4 border-b">
            <h2 class="text-lg font-bold">Failed Records (Option 2)</h2>
        </div>
        <div class="flex justify-end gap-4 p-4 border-t">
            <button id="closeFailedRowsModal" onclick="closeModal('#failedRowsModal')"
                class="px-4 py-2 text-white bg-red-500 rounded">Close</button>
            <button id="printFailedRowsModal" onclick="printFailedRows('#failedRowsModal')"
                class="px-4 py-2 text-white bg-blue-500 rounded">Print</button>

        </div>
        <div class="p-4 overflow-auto text-sm modal-body">
            <table class="w-full text-sm border border-collapse border-gray-300 text-nowrap text-center">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="px-3 border-2 border-black">Line</th>
                        <th class="px-3 border-2 border-black">EnNo</th>
                        <th class="px-3 border-2 border-black">IN/OUT</th>
                        <th class="px-3 border-2 border-black">DateTime</th>
                        <th class="px-3 border-2 border-black">Error</th>
                    </tr>
                </thead>
                <tbody id="failedRowsTable">
                    <!-- Failed rows will be appended here -->
                </tbody>
            </table>
        </div>

    </div>
</div>
<!-- Edit Modal --><!-- Edit Attendance Modal -->
<div id="editModal" class="fixed inset-0 flex items-center justify-center hidden bg-gray-900 bg-opacity-50">
    <div class="p-6 bg-white rounded-lg shadow-lg w-96">
        <h2 class="mb-4 text-xl font-semibold">Edit Attendance</h2>
        <form id="editForm">
            @csrf
            @method('PUT')
            <input type="hidden" id="editRecordId">

            <div class="mb-4">
                <label for="editEmployeeId" class="block text-sm font-medium text-gray-700">Employee</label>
                <select id="editEmployeeId" name="employee_id" class="w-full p-2 border border-gray-300 rounded">
                    @foreach ($employees as $employee)
                        <option value="{{ $employee->id }}">
                            {{ $employee->first_name }} {{ $employee->middle_name }} {{ $employee->last_name }}
                        </option>
                    @endforeach
                </select>
            </div>
            @php
                $departments = App\Models\Department::all();
            @endphp
            <div class="mb-4">
                <label for="editDepartmentId" class="block text-sm font-medium text-gray-700">Department</label>
                <select id="editDepartmentId" name="department_id" class="w-full p-2 border border-gray-300 rounded">
                    @foreach ($departments as $department)
                        <option value="{{ $department->id }}">{{ $department->department_name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="mb-4">
                <label for="editDate" class="block text-sm font-medium text-gray-700">Date</label>
                <input type="date" id="editDate" name="date" class="w-full p-2 border border-gray-300 rounded">
            </div>

            <div class="mb-4">
                <label for="editTimeIn" class="block text-sm font-medium text-gray-700">Time In</label>
                <input type="time" id="editTimeIn" name="time_in" class="w-full p-2 border border-gray-300 rounded">
            </div>

            <div class="mb-4">
                <label for="editTimeOut" class="block text-sm font-medium text-gray-700">Time Out</label>
                <input type="time" id="editTimeOut" name="time_out"
                    class="w-full p-2 border border-gray-300 rounded">
            </div>

            <div class="mb-4">
                <label for="editNotes" class="block text-sm font-medium text-gray-700">Notes</label>
                <textarea id="editNotes" name="notes" class="w-full p-2 border border-gray-300 rounded"></textarea>
            </div>

            <div class="flex justify-between">
                <button type="button" onclick="closeModal('editModal')"
                    class="px-4 py-2 text-white bg-gray-500 rounded">
                    Cancel
                </button>
                <button type="submit" class="px-4 py-2 text-white bg-blue-600 rounded">
                    Update Attendance
                </button>
            </div>
        </form>
    </div>
</div>


<!-- Delete Modal -->
<div id="deleteModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
    <div class="bg-white rounded-lg shadow-lg p-6 w-auto md:w-[30rem] mt-20">
        <h2 class="mb-4 text-lg font-bold">Delete Record</h2>
        <p>Are you sure you want to delete this record?</p>
        <form id="deleteForm">
            @csrf
            <input type="hidden" id="deleteRecordId" name="id">
            <div class="flex justify-end mt-6">
                <button type="button" onclick="closeModal('deleteModal')"
                    class="px-4 py-2 mr-2 text-gray-700 bg-gray-200 rounded">Cancel</button>
                <button type="submit" class="px-4 py-2 text-white bg-red-600 rounded">Delete</button>
            </div>
        </form>
    </div>
</div>
