<div class="relative w-full bg-black bg-opacity-80">
    <div id="agencymodal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
        <div class="bg-white rounded-lg shadow-lg p-6 w-auto  mt-20">
            <div class="flex flex-col px-5 py-4 bg-white rounded-2xl">
                <div class="flex items-center justify-between pb-4 border-b border-gray-200">
                    <h4 class="text-sm font-medium text-gray-900">Create New Agency</h4>
                    <button class="block cursor-pointer close-modal-button" onclick="closeModal('agencymodal')">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path d="M7.75732 7.75739L16.2426 16.2427M16.2426 7.75739L7.75732 16.2427" stroke="black"
                                stroke-width="1.6" stroke-linecap="round" />
                        </svg>
                    </button>
                </div>
                <div class="w-full p-8 mx-auto my-10 bg-white border border-gray-200 rounded-lg shadow-md">

                    <form action="{{ route('agencies.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <!-- Agency Name -->
                            <div>
                                <label for="name" class="block text-sm font-medium text-gray-700">Agency
                                    Name</label>
                                <input type="text" name="name" id="name"
                                    class="mt-1 block w-full border-2 border-black h-10 rounded-md shadow-sm 
                                       @error('name') border-red-500 @enderror"
                                    value="{{ old('name') }}" required>
                                @error('name')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Upload Logo -->
                            <div>
                                <label for="image" class="block text-sm font-medium text-gray-700">Upload
                                    Logo</label>
                                <input type="file" name="image" id="image" accept="image/*"
                                    class="mt-1 block w-full  h-10 rounded-md shadow-sm 
                                       @error('image') border-red-500 @enderror">
                                @error('image')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Contact Phone -->
                            <div>
                                <label for="contact_phone" class="block text-sm font-medium text-gray-700">Contact
                                    Phone</label>
                                <input type="text" name="contact_phone" id="contact_phone"
                                    class="mt-1 block w-full border-2 border-black h-10 rounded-md shadow-sm 
                                       @error('contact_phone') border-red-500 @enderror"
                                    value="{{ old('contact_phone') }}" required>
                                @error('contact_phone')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Address -->
                            <div>
                                <label for="address" class="block text-sm font-medium text-gray-700">Address</label>
                                <input type="text" name="address" id="address"
                                    class="mt-1 block w-full border-2 border-black h-10 rounded-md shadow-sm 
                                       @error('address') border-red-500 @enderror"
                                    value="{{ old('address') }}" required>
                                @error('address')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <div class="flex justify-center">
                            <button type="submit" class="px-4 py-2 mt-4 text-white bg-green-600 rounded-md">
                                Create Agency
                            </button>
                        </div>
                    </form>


                </div>
            </div>
        </div>
    </div>
</div>




@foreach ($data as $client)
    <!-- Update Modal for each client -->
    <div id="updateModal{{ $client->id }}"
        class="fixed inset-0 z-50 flex items-start justify-center hidden bg-black bg-opacity-50 modal fade">
        <!-- Modal dialog -->
        <div class="w-1/2 mx-auto mt-10 overflow-hidden bg-white rounded-lg shadow-xl">
            <!-- Modal header -->
            <div class="flex items-center justify-between px-4 py-2 ">
                <h5 class="text-sm font-medium text-gray-900">Edit Agency</h5>
                <button onclick="closeModal('updateModal{{ $client->id }}')" class="">&times;</button>
            </div>
            <div class="text-white modal-header bg-primary">
                <h5 class="modal-title" id="updateModalLabel{{ $client->id }}">Update Client Information</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="w-full p-8 mx-auto my-10 bg-white border border-gray-200 rounded-lg shadow-md">
                <!-- Update Form -->
                <form action="{{ route('agencies.update', $client->id) }}" method="POST"
                    enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <div class="grid grid-cols-2 gap-4">
                        <!-- Name Field -->
                        <div>
                            <label for="name{{ $client->id }}"
                                class="block text-sm font-medium text-gray-700">Name</label>
                            <input type="text"
                                class="block w-full h-10 mt-1 border-2 border-black rounded-md shadow-sm"
                                id="name{{ $client->id }}" name="name" value="{{ $client->name }}">
                        </div>

                        <!-- Upload Logo Field -->
                        <div>
                            <label for="image" class="block text-sm font-medium text-gray-700">Upload Logo</label>
                            <input type="file" name="image" id="image" accept="image/*"
                                class="mt-1 block w-full  h-10 rounded-md shadow-sm 
                                   @error('image') border-red-500 @enderror">
                            @error('image')
                                <span class="text-sm text-red-500">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- Contact Phone Field -->
                        <div>
                            <label for="contact_phone{{ $client->id }}"
                                class="block text-sm font-medium text-gray-700">Contact Phone</label>
                            <input type="text"
                                class="block w-full h-10 mt-1 border-2 border-black rounded-md shadow-sm"
                                id="contact_phone{{ $client->id }}" name="contact_phone"
                                value="{{ $client->contact_phone }}">
                        </div>

                        <!-- Address Field -->
                        <div>
                            <label for="address{{ $client->id }}"
                                class="block text-sm font-medium text-gray-700">Address</label>
                            <input type="text"
                                class="block w-full h-10 mt-1 border-2 border-black rounded-md shadow-sm"
                                id="address{{ $client->id }}" name="address" value="{{ $client->address }}">
                        </div>
                    </div>

                    <!-- Modal Footer -->
                    <div class="flex justify-center">
                        <button type="submit"
                            class="px-4 py-2 mt-4 text-white bg-green-600 rounded-md">Update</button>
                    </div>
                </form>

            </div>
        </div>
    </div>
    <div id="deleteModal{{ $client->id }}"
        class="fixed inset-0 z-50 flex items-start justify-center bg-gray-800 bg-opacity-60 hidden">
        <div class="max-w-md mx-auto bg-white rounded-lg shadow-md overflow-hidden mt-20">
            <div class="flex justify-between items-center bg-gray-700 p-4 rounded-t-lg">
                <h5 class="font-semibold text-lg text-white">Confirm Delete</h5>
                <button onclick="closeModal('deleteModal{{ $client->id }}')" class="text-white">&times;</button>
            </div>

            <!-- Modal body -->
            <div class="px-4 py-4">
                <p class="text-sm text-gray-700">Are you certain you want to delete this agency ({{ $client->name }})?
                    Doing so will affect the
                    related companies and
                    clients.</p>
            </div>

            <!-- Modal footer -->
            <!-- Modal Footer -->
            <div class="flex justify-end space-x-4 px-6 py-4 bg-gray-50 rounded-b-lg">

                <button onclick="closeModal('deleteModal{{ $client->id }}')"
                    class="px-3 py-1 mr-2 text-gray-800 bg-gray-300 rounded hover:bg-gray-400">Cancel</button>

                <!-- Form for delete -->
                <form id="deleteForm{{ $client->id }}" action="{{ route('agencies.destroy', $client->id) }}"
                    method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="submit"
                        class="px-3 py-1 text-white bg-red-500 rounded hover:bg-red-600">Delete</button>
                </form>
            </div>
        </div>
    </div>
@endforeach
<script>
    function openModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }

    // Function to close a modal
    function closeModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.add('hidden');
        modal.classList.remove('flex');
    }
</script>
