<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\DatabaseMessage;

class DepartmentEndNotification extends Notification
{
    use Queueable;

    protected $department;

    public function __construct($department)
    {
        $this->department = $department;
    }

    public function via($notifiable)
    {
        return ['database']; // Store in the database
    }

    public function toArray($notifiable)
    {
        return [
            'message' => "Department '{$this->department->department_name}' is ending on {$this->department->end}!",
            'department_id' => $this->department->id,
            'end_date' => $this->department->end,
        ];
    }
}
