<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WorkSchedule extends Model
{
    use HasFactory;

    protected $table = 'employee_sched'; // Define the table name if different

    protected $fillable = [
        'employee_id',
        'shift_id',
        'start_date',
        'end_date',
        'status',
    ];


    // Relationships
    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function shift()
    {
        return $this->belongsTo(Shift::class, 'shift_id');
    }
}
