<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'role_id',
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function role()
    {
        return $this->belongsTo(Role::class);
    }
    public function hasAgencyRestrictions()
    {
        return !empty($this->viewable_agency_ids);
    }
    public function employee()
    {
        return $this->hasOne(Employee::class);
    }

    public function getViewableAgencyIdsAttribute()
    {
        // Ensure the 'agencies' relationship is loaded and return the ids of the agencies
        return $this->agencies()->pluck('agencies.id')->toArray();
    }

    public function agencies()
    {
        return $this->belongsToMany(Agency::class, 'assign', 'user_id', 'agency_id');
    }
}
