<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TrxCode extends Model
{
    use HasFactory;

    protected $table = 'trx_codes';

    protected $fillable = [
        'group_code_id',
        'description',
        'abbreviation',
        'percentage',
        'entry_order',
        'sub_category',
    ];

    public function groupCode()
    {
        return $this->belongsTo(TrxGroupcode::class, 'group_code_id');
    }

    public function channels()
    {
        return $this->hasMany(TrxChannel::class, 'code_id');
    }
    public function options()
    {
        return $this->hasManyThrough(TrxOption::class, TrxChannel::class, 'code_id', 'id', 'id', 'option_id');
    }

    public function loans()
    {
        return $this->hasMany(TrxLoan::class, 'group_code_id');
    }
    public function constant()
    {
        return $this->hasMany(TrxConstant::class, 'group_code_id');
    }
}
