<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TrxChannel extends Model
{
    use HasFactory;

    protected $table = 'trx_channels';

    protected $fillable = [
        'code_id',
        'option_id',
    ];

    public function code()
    {
        return $this->belongsTo(TrxCode::class, 'code_id');
    }

    public function option()
    {
        return $this->belongsTo(TrxOption::class, 'option_id');
    }
}
