<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StoreDepartment extends Model
{
    use HasFactory;
    protected $table = 'store_departments';
    protected $fillable = [
        'store_id',
        'department_id',
    ];

    // Relationships (optional)
    public function store()
    {
        return $this->belongsTo(Stores::class);
    }

    public function department()
    {
        return $this->belongsTo(Department::class);
    }
}
