<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PtsrTrx extends Model
{
    use HasFactory;

    protected $table = 'ptsr_trx'; // Define the table name explicitly

    protected $fillable = [
        'ptsr_id',
        'code_id',
        'amount',
        'type',
        'created_at',
        'updated_at',
    ];

    public function ptsr()
    {
        return $this->belongsTo(Ptsr::class, 'ptsr_id');
    }

    public function code()
    {
        return $this->belongsTo(TrxCode::class, 'code_id');
    }
}
