<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Ptsr extends Model
{
    use HasFactory;

    protected $table = 'ptsr';

    // Define fillable properties for mass assignment
    protected $fillable = [
        'employee_id',
        'department_id',
        'under_time',
        'total',
        'adj',
        'ot',
        'night',
        'special_premium',
        'legal_holiday',
        'duty',
        'number_of_days',
        'start_date',   // Include start_date
        'end_date',     // Include end_date
        'status',
        'status2',
    ];

    // Define the relationship with the Employee model
    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
    public function department()
    {
        return $this->belongsTo(Department::class);
    }
    public function transactions()
    {
        return $this->hasMany(PtsrTrx::class, 'ptsr_id');
    }
}
