<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PersonInCharge extends Model
{
    use HasFactory;

    // Define the table name
    protected $table = 'person_incharge';

    // Define the fillable fields
    protected $fillable = [
        'batch_id',
        'person_incharge_id',
        'status',
    ];

    // Define the relationship with the User model (person_incharge_id)
    public function user()
    {
        return $this->belongsTo(User::class, 'person_incharge_id');
    }
}
