<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PersonApprove extends Model
{
    use HasFactory;

    // Define the table name
    protected $table = 'person_approve';

    // Define the fillable fields
    protected $fillable = [
        'batch_id',
        'person_approved_id',
        'status',
    ];

    // Define the relationship with the User model (person_approved_id)
    public function user()
    {
        return $this->belongsTo(User::class, 'person_approved_id');
    }
}
