<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PagibigPercentage extends Model
{
    use HasFactory;

    // Table name
    protected $table = 'pagibig_rate';

    // Primary key
    protected $primaryKey = 'id';

    // Auto-incrementing is enabled
    public $incrementing = true;

    // Primary key type
    protected $keyType = 'int';

    // Laravel expects created_at and updated_at
    public $timestamps = true;

    // Mass assignable fields
    protected $fillable = [
        'from',
        'to',
        'percent_employee',
        'percent_employer',
        'employee_fixedamount',
        'employer_fixedamount',
        'fixed1',
        'fixed2',
        'type',
    ];

    // Casts for correct data handling
    protected $casts = [
        'from' => 'decimal:2',
        'to' => 'decimal:2',
        'percent_employee' => 'decimal:2',
        'percent_employer' => 'decimal:2',
        'employee_fixedamount' => 'decimal:2',
        'employer_fixedamount' => 'decimal:2',
    ];
}
