<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OtherTrxOption extends Model
{
    use HasFactory;

    protected $table = 'others_trx_options';  // Specify the table name

    protected $fillable = [
        'other_trx',
        'payroll_id',
        'Amount',
        'status',
        'descriptions',
    ];

    // Relationship with OtherTrx model
    public function otherTrx()
    {
        return $this->belongsTo(OtherTrx::class, 'other_trx');
    }

    // Relationship with Payroll model (assuming a Payroll model exists)
    public function payroll()
    {
        return $this->belongsTo(Payroll::class, 'payroll_id');
    }
}
