<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OtherTrx extends Model
{
    use HasFactory;

    protected $table = 'other_trx';  // Specify the table name

    protected $fillable = [
        'employee_id',
        'group_code_id',
        '1st',
        '2st',
        'dr',
        'status',
        'date',
        'description',
    ];

    // Relationship with Employee model (assuming an Employee model exists)
    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }

    // Relationship with TrxCode model (assuming a TrxCode model exists)
    public function groupCode()
    {
        return $this->belongsTo(TrxCode::class, 'group_code_id');
    }

    // Relationship with OtherTrxOption model (assuming the related model is named OtherTrxOption)
    public function options()
    {
        return $this->hasMany(OtherTrxOption::class, 'other_trx');
    }
}
