<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MrfMoreDetail extends Model
{
    use HasFactory;

    protected $table = 'mrf_moredetails';

    protected $fillable = [
        'mrf_id',
        'per_store',
        'frequency',
    ];

    /**
     * Get the requisition associated with the more details.
     */
    public function requisition()
    {
        return $this->belongsTo(Requisition::class, 'mrf_id');
    }
}
