<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MinimumWage extends Model
{
    protected $fillable = [
        'default_rate_id',
        'amount',
        'amount_added',
        'effective_date',
        'status',
        'expiry_date'
    ];

    public function default_rate()
    {
        return $this->belongsTo(DefaultRate::class);
    }

    public function employeeWageAssignments()
    {
        return $this->hasMany(EmployeeWageAssignment::class);
    }
}
