<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeeContribution extends Model
{
    use HasFactory;

    // Define the table name if it's different from the plural form
    protected $table = 'employee_contributions';

    // Define the fillable fields for mass assignment
    protected $fillable = [
        'employee_id',
        'monthly_salary',
        'sss_contribution_employee',
        'sss_contribution_employer',
        'philhealth_contribution_employee',
        'philhealth_contribution_employer',
        'pagibig_contribution_employee',
        'pagibig_contribution_employer',
    ];


    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
}
