<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
use Illuminate\Support\Collection;

class Employee extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'dtr_id',
        'first_name',
        'position_applied',
        'bank_number',
        'bank_name',
        'desired_working_area',
        'middle_name',
        'last_name',
        'present_address',
        'provincial_address',
        'mobile_number',
        'alternative_number',
        'date_of_birth',
        'age',
        'place_of_birth',
        'civil_status',
        'nationality',
        'religion',
        'height',
        'weight',
        'spouse_name',
        'spouse_occupation',
        'mother_maiden_name',
        'mother_occupation',
        'father_name',
        'father_occupation',
        'sss_no',
        'tin_no',
        'pagibig_no',
        'dependents',
        'philhealth_no',
        'blood_type',
        'education_school',
        'education_course_level',
        'education_year',
        'relevant_qualifications',
        'company_name',
        'employment_start',
        'employment_end',
        'position',
        'salary',
        'emergency_contact_name',
        'emergency_contact_number',
        'emergency_contact_address',
        'emergency_contact_occupation',
        'emergency_contact_relation',
        'emergency_contact_company',
        'emergency_contact_business_tel',
        'status',
        'bank_status',
        'clearance_status',
        'claim_type',
        'profile',
        'sex',
        'store_id',
        'office_id',
        'pwd',
        'pwd_file',
        'is_shift',
    ];

    public function ptsr()
    {
        return $this->hasMany(Ptsr::class, 'employee_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function channelclient()
    {
        return $this->hasMany(EmployeeClientChannel::class, 'employee_id');
    }
    public function worksched()
    {
        return $this->hasMany(WorkSchedule::class, 'employee_id');
    }
    public function employeeClientChannels()
    {
        return $this->hasMany(EmployeeClientChannel::class);
    }
    public function employeerate()
    {
        return $this->hasMany(Employeerate::class);
    }


    public function contributions()
    {
        return $this->hasMany(EmployeeContribution::class);
    }
    public function payrolls()
    {
        return $this->hasMany(Payroll::class);
    }
    // Define a method to get employees who are not assigned
    public function mrfapplicant()
    {
        return $this->hasMany(MrfApplicant::class, 'employee_id');
    }
    public function attendance()
    {
        return $this->hasMany(Attendance::class);
    }
    public function trxconstants()
    {
        return $this->hasMany(TrxConstant::class);
    }
    public function workSchedules()
    {
        return $this->hasMany(WorkSchedule::class, 'employee_id');
    }

    public static function upcomingBirthdays(int $days = 30): Collection
    {
        $today = Carbon::today();
        $endDate = $today->copy()->addDays($days);

        return self::all()->filter(function ($employee) use ($today, $endDate) {
            if (!$employee->date_of_birth) {
                return false;
            }

            $dob = Carbon::parse($employee->date_of_birth);
            $nextBirthday = Carbon::createFromDate($today->year, $dob->month, $dob->day);

            // If the birthday already passed this year, move to next year
            if ($nextBirthday->lessThan($today)) {
                $nextBirthday->addYear();
            }

            return $nextBirthday->between($today, $endDate);
        })->sortBy(function ($employee) {
            return Carbon::parse($employee->date_of_birth)->format('md');
        });
    }
    public function hasUpcomingBirthday(int $days = 30): bool
    {
        if (!$this->date_of_birth) {
            return false;
        }

        $today = Carbon::today();
        $endDate = $today->copy()->addDays($days);

        $dob = Carbon::parse($this->date_of_birth);
        $nextBirthday = Carbon::createFromDate($today->year, $dob->month, $dob->day);

        if ($nextBirthday->lessThan($today)) {
            $nextBirthday->addYear();
        }

        return $nextBirthday->between($today, $endDate);
    }

}
