<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConstantDeduction extends Model
{
    use HasFactory;

    protected $table = 'constantdeductions';  // This specifies the table name if it's not the plural form of the model name.

    protected $fillable = [
        'trx_constants_id', // Foreign key to trx_constants table
        'payroll_id', // Foreign key to payrolls table
        'status',
        'E_Amount', // The amount of deduction
        'Er_Amount',
        'e_amount_ad',
        'er_amount_ad',
    ];

    /**
     * Get the trx_constant that owns the constant deduction.
     */
    public function trxConstant()
    {
        return $this->belongsTo(TrxConstant::class, 'trx_constants_id');
    }

    /**
     * Get the payroll associated with the constant deduction.
     */
    public function payroll()
    {
        return $this->belongsTo(Payroll::class, 'payroll_id');
    }
}
