<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClientBank extends Model
{
    use HasFactory;

    protected $table = 'clientbankprofile';

    protected $fillable = [
        'bankprofile_id',
        'department_id',
        'company_code',
        'branch_code',
        'filler',
        'more',
    ];
    public function bankProfile()
    {
        return $this->belongsTo(BankProfile::class, 'bankprofile_id');
    }

    public function department()
    {
        return $this->belongsTo(Department::class, 'department_id');
    }
}
