<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ChargeGroup extends Model
{
    use HasFactory;
    protected $table = 'charges_channel';
    protected $fillable = [
        'charges_id',
        'group_code_id',
        'type',
    ];

    // Define relationships
    public function charge()
    {
        return $this->belongsTo(Charges::class, 'charges_id');
    }

    public function groupCode()
    {
        return $this->belongsTo(TrxCode::class, 'group_code_id');
    }
}
