<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Batchcode extends Model
{
    use HasFactory;

    protected $table = 'batchcode'; // Specify the table name

    protected $fillable = [
        'department_id',
        'pay_period_start',
        'pay_period_end',
        'scope_start',
        'scope_end',
        'status',
        'status2',
        'contributiontype',
        'description',
        'with_adjustment',
        'display_late',
    ];

    public function payrolls()
    {
        return $this->hasMany(Payroll::class, 'code_id');
    }
    // public function department()
    // {
    //     return $this->hasMany(Department::class, 'department_id');
    // }
    public function client()
    {
        return $this->belongsTo(Department::class, 'department_id');
    }
}
