<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Attendance extends Model
{
    use HasFactory;
    protected $fillable = ['employee_id', 'department_id', 'date', 'time_in', 'time_out', 'break_out', 'break_in', 'ot_in', 'ot_out', 'selfie', 'ot', 'status', 'approve', 'notes'];

    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }
    public function department()
    {
        return $this->belongsTo(Department::class, 'department_id');
    }
}
