<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssignCompany extends Model
{
    use HasFactory;
    protected $table = 'assigncompany'; // Change if your table name is different

    protected $fillable = [
        'assign_id',
        'company_id',
    ];

    public function company()
    {
        return $this->belongsTo(Client::class, 'company_id');
    }

    public function assign()
    {
        return $this->belongsTo(Assign::class, 'assign_id');
    }
}
