<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class CheckPrivileges
{
    public function handle($request, Closure $next)
    {
        // Get the authenticated user
        $user = Auth::user();

        // Share privileges globally
        if ($user) {
            $privileges = $user->role->privileges->pluck('privilege_name')->toArray();
        } else {
            $privileges = [];
        }

        // Share the privileges with all views and controllers
        view()->share('privileges', $privileges, '$user');
        $request->attributes->set('privileges', $privileges, '$user');

        return $next($request);
    }
}
