<?php

namespace App\Http\Controllers;

use App\Models\TrxLoan;
use App\Models\TrxCode;
use App\Models\Employee;
use App\Models\TRXloandeductions;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class TrxLoanController extends Controller
{
    public function employee_loans(Request $request, $id)
    {
        if ($request->ajax()) {
            $data = TrxLoan::with('trx_code')->where('employee_id', $id)->get();
            return DataTables::of($data)

                ->addColumn('endingbalance', function ($row) {
                    $totalAmount = TRXloandeductions::where('trx_loans_id', $row->id)->sum('Amount');

                    $total = $row->total_amount - $totalAmount;

                    // Return formatted ending balance
                    return number_format($total, 2);
                })

                ->addColumn('description', function ($row) {

                    $trx = TrxCode::find($row->group_code_id);

                    return $trx->description;
                })
                ->addColumn('action', function ($row) {
                    // Action buttons (edit, delete)
                    $actionBtn = '<div class="flex items-center justify-center gap-2">
                <button class="flex items-center justify-center w-10 h-10 text-white bg-red-600 rounded-md delete-btn" 
                data-url="' . route('trx_loans.destroy', $row->id) . '" data-id="' . $row->id . '">
                <i class="text-xl bx bx-trash-alt"></i>
                </button>
            </div>';
                    return $actionBtn;
                })
                ->make(true);
        }
    }

    public function updateCheckbox(Request $request, $id)
    {
        // Find the TrxLoan by ID
        $trxLoan = TrxLoan::find($id);

        // Check if the field exists in the request and update accordingly
        if ($trxLoan) {
            $column = $request->column;
            $value = $request->value == '1' ? 1 : 0; // Set 1 for checked, 0 for unchecked

            // Update the specific field (status, 1st, or 2st)
            $trxLoan->$column = $value;
            $trxLoan->save();

            return response()->json(['success' => true]);
        }

        return response()->json(['success' => false], 400);
    }

    public function create()
    {
        return view('trx_loans.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'employee_id' => 'required|exists:employees,id',
            'group_code_id' => 'required',
            '1st' => 'nullable|string',
            '2st' => 'nullable|string',
            'seq' => 'nullable|string',
            'status' => 'nullable|string',
            'date' => 'nullable|string',
            'reference' => 'nullable|string',
            'total_amount' => 'nullable|string',
            'installment' => 'nullable|string',
        ]);

        TrxLoan::create($validated);

        return redirect()->back()->with('success', 'Added Successfully.');
    }

    public function show($id)
    {
        return TrxLoan::findOrFail($id);
    }

    public function edit($id)
    {
        $trxLoan = TrxLoan::findOrFail($id);
        return view('trx_loans.edit', compact('trxLoan'));
    }

    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'employee_id' => 'required|exists:employees,id',
            'trx_name' => 'nullable|string',
            '1st' => 'nullable|string',
            '2st' => 'nullable|string',
            'seq' => 'nullable|string',
            'status' => 'nullable|string',
            'date' => 'nullable|string',
            'reference' => 'nullable|string',
            'total_amount' => 'nullable|string',
            'installment' => 'nullable|string',
        ]);

        $trxLoan = TrxLoan::findOrFail($id);
        $trxLoan->update($validated);

        return redirect()->route('trx_loans.index');
    }

    public function destroy($id)
    {
        $trxLoan = TrxLoan::findOrFail($id); // Ensure the record exists
        $trxLoan->delete(); // Delete the record

        return response()->json(['success' => true, 'message' => 'Loan deleted successfully!']);
    }
}
