<?php

namespace App\Http\Controllers;

use App\Models\Department;
use Illuminate\Http\Request;
use App\Models\StoreDepartment;
use App\Models\Stores;
use Yajra\DataTables\Facades\DataTables;
class StoreDepartmentController extends Controller
{
    public function index(Request $request, $id)
    {
        if ($request->ajax()) {
            $data = StoreDepartment::with('store')->where('department_id', $id);

            return DataTables::of($data)
                ->addColumn('name', function ($row) {

                    return $row->store->name;
                })
                ->addColumn('action', function ($row) {

                    $deleteBtn = '<button class="flex items-center justify-center w-10 h-10 text-white bg-red-600 rounded-md delete-file" data-id="' . $row->id . '">
                                <i class="text-xl bx bx-trash-alt"></i>
                            </button>';

                    return '<div class="flex items-center justify-center gap-2">' . $deleteBtn . '</div>';
                })

                ->rawColumns(['action'])
                ->make(true);
        }
    }

    public function storesapi($id)
    {

        $storedepartment_id = StoreDepartment::where('department_id', $id)
            ->pluck('store_id')
            ->toArray();
        $stores = Stores::whereNotIn('id', $storedepartment_id)->get();

        return response()->json(['data' => $stores], 200);

    }
    public function store(Request $request)
    {
        $validated = $request->validate([
            'store_id' => 'required|exists:stores,id',
            'department_id' => 'required|exists:department,id'
        ]);

        StoreDepartment::create($validated);

        return response()->json([
            'success' => true,
            'message' => 'Store assigned successfully'
        ]);
    }

    public function assignstore(Request $request, $id)
    {
        $query = StoreDepartment::with('store', 'department')
            ->where('store_id', $id);

        if ($request->ajax()) {
            return DataTables::of($query)
                ->addColumn('department', function ($row) {
                    return $row->department ? $row->department->department_name : '-';
                })
                ->addColumn('action', function ($row) {
                    $deleteBtn = '<button class="flex items-center justify-center w-10 h-10 text-white bg-red-600 rounded-md delete-file" data-id="' . $row->id . '">
                                <i class="text-xl bx bx-trash-alt"></i>
                              </button>';
                    return '<div class="flex items-center justify-center gap-2">' . $deleteBtn . '</div>';
                })
                ->rawColumns(['action'])
                ->make(true);
        }

        $department = Department::all();

        // Important: don’t pass a query builder to the view
        return view('Admin.Store.storeassign', compact('department', 'id'));
    }
    public function update(Request $request, $id)
    {
        $validated = $request->validate([]);
    }
    public function destroy($id)
    {
        $storedep = StoreDepartment::find($id);
        $storedep->delete();
        return response()->json([
            'success' => true,
            'message' => 'Store assigned deleted successfully'
        ]);
    }
}
