<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Contribution;
use App\Models\Privilege;
use App\Models\Role;
use App\Models\shift;
use App\Models\Offices;
use App\Models\Stores;
use App\Models\User;
use App\Models\Charges;
use Yajra\DataTables\DataTables;
use App\Models\MonthlyRate;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Models\PagibigPercentage;

class SettingsController extends Controller
{
    public function index()
    {
        $perPage = 10;
        $sss = Contribution::where('benefit_name', 'SSS')->latest()->first();
        $phil = Contribution::where('benefit_name', 'PhilHealth')->latest()->first();
        $pag = Contribution::where('benefit_name', 'Pag-IBIG')->latest()->first();
        $contribution = Contribution::all();
        $contribution1 = Contribution::all();
        $privileges1 = Privilege::all();
        $pagibignew = PagibigPercentage::where('type', 'pagibig')->get();
        $philhealthnew = PagibigPercentage::where('type', 'philhealth')->get();


        $role = Role::all();

        $rates = MonthlyRate::with('contribution')
            ->whereHas('contribution', function ($query) {
                $query->where('benefit_name', 'SSS');
            })
            ->paginate($perPage);
        return view('Admin.Settings.index', compact('contribution', 'pagibignew', 'philhealthnew', 'contribution1', 'sss', 'phil', 'pag', 'privileges1', 'role', 'rates'));
    }
    public function storeindex(Request $request)
    {
        if ($request->ajax()) {
            $data = Stores::get();
            return DataTables::of($data)
                ->make(true);
        }
    }
    public function officesindex(Request $request)
    {
        if ($request->ajax()) {
            $data = Offices::get();
            return DataTables::of($data)
                ->make(true);
        }
    }

    public function storeoffives(Request $request)
    {
        $validated = $request->validate([
            'name' => 'nullable|string|max:255',
        ]);

        Offices::create($validated);

        return redirect()->back()->with('success', 'Offices created successfully!');
    }
    public function storestores(Request $request)
    {
        $validated = $request->validate([
            'department_id' => 'required|exists:department,id',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:3',
            'name' => 'nullable|string|max:255',
        ]);

        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'role_id' => 23,
        ]);

        Stores::create([
            'department_id' => $validated['department_id'],
            'user_id' => $user->id,
            'name' => $request->name,
        ]);

        return response()->json(200);
    }
    public function edit($id)
    {
        $store = Stores::with('user')->findOrFail($id);

        return response()->json([
            'id' => $store->id,
            'name' => $store->name,
            'email' => $store->user->email,
        ]);
    }

    public function update(Request $request, $id)
    {
        $store = Stores::findOrFail($id);
        $user = $store->user;

        $validated = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255|unique:users,email,' . $user->id,
            'password' => 'nullable|string|min:3'
        ]);

        if ($validated->fails()) {
            return response()->json(['errors' => $validated->errors()], 422);
        }

        $store->update(['name' => $request->name]);

        $user->name = $request->name;
        $user->email = $request->email;
        if ($request->filled(key: 'password')) {
            $user->password = Hash::make($request->password);
        }
        $user->save();

        return response()->json(['message' => 'Store updated successfully']);
    }
}
