<?php

namespace App\Http\Controllers;

use App\Models\SettingForPayroll;
use Illuminate\Http\Request;

class SettingForPayrollController extends Controller
{
    public function index()
    {
        $settings = SettingForPayroll::with('client')->get();
        return view('Admin', compact('settings'));
    }

    public function create()
    {
        return view('settings.create');
    }

    public function store(Request $request)
    {
        // Validate the incoming data, including the client_id
        $validatedData = $request->validate([
            'client_id' => 'required|exists:clients,id', // Ensure client_id exists in the clients table
            'total_days_column' => 'nullable|boolean',
            'late_column' => 'nullable|boolean',
            'numberdays_column' => 'nullable|boolean',
            'hours_column' => 'nullable|boolean',
            'ot_column' => 'nullable|string',
            'drd_column' => 'nullable|boolean',
            'sh_column' => 'nullable|boolean',
            'transpo_column' => 'nullable|boolean',
        ]);

        // Save the settings, including the client_id
        SettingForPayroll::create($validatedData);

        // If the request is AJAX, return a JSON response
        if ($request->ajax()) {
            return response()->json(['success' => 'Settings saved successfully!']);
        }

        // Otherwise, redirect (fallback)
        return redirect()->back()->with('success', 'Settings saved successfully!');
    }

    // public function edit($id)
    // {
    //     $settings = SettingForPayroll::find($id)->latest();
    //     return view('Admin.Client.setting.index', compact('settings'));
    // }

    public function update(Request $request, $id)
    {
        // Validate the incoming data
        $validatedData = $request->validate([
            'total_days_column' => 'nullable|boolean',
            'late_column' => 'nullable|boolean',
            'numberdays_column' => 'nullable|boolean',
            'hours_column' => 'nullable|boolean',
            'ot_column' => 'nullable|string',
            'drd_column' => 'nullable|boolean',
            'sh_column' => 'nullable|boolean',
            'transpo_column' => 'nullable|boolean',
        ]);

        // Find the setting record
        $setting = SettingForPayroll::findOrFail($id);

        // Update the fields directly using the validated data
        $setting->update([
            'total_days_column' => $validatedData['total_days_column'] ?? false,
            'late_column' => $validatedData['late_column'] ?? false,
            'numberdays_column' => $validatedData['numberdays_column'] ?? false,
            'hours_column' => $validatedData['hours_column'] ?? false,
            'ot_column' => $validatedData['ot_column'] ?? false,
            'drd_column' => $validatedData['drd_column'] ?? false,
            'sh_column' => $validatedData['sh_column'] ?? false,
            'transpo_column' => $validatedData['transpo_column'] ?? false,
        ]);

        // Return JSON for AJAX requests
        if ($request->ajax()) {
            return response()->json(['message' => 'Settings updated successfully!'], 200);
        }

        // Redirect for non-AJAX requests
        return redirect()
            ->route('settings.index') // Assuming 'settings.index' is the route name for listing settings
            ->with('success', 'Settings updated successfully!');
    }


    public function destroy(SettingForPayroll $setting)
    {
        $setting->delete();
        return redirect()->route('settings.index')->with('success', 'Setting deleted successfully.');
    }
}
