<?php

namespace App\Http\Controllers;

use App\Models\MrfApplicant;
use App\Models\Requisition;
use App\Models\MrfAction;
use Illuminate\Http\Request;

class MrfApplicantController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $applicants = MrfApplicant::with(['employee', 'requisition'])->get();
        return view('mrf_applicant.index', compact('applicants'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        // Load required data for the form (e.g., employees and requisitions)
        return view('mrf_applicant.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'requisition_id' => 'required|exists:requisitions,id',
            'employee_id' => 'required|exists:employees,id',
            'status' => 'required|string',
        ]);

        MrfApplicant::create($request->all());

        return redirect()->route('mrf_applicant.index')->with('success', 'Applicant added successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(MrfApplicant $mrfApplicant)
    {
        return view('mrf_applicant.show', compact('mrfApplicant'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(MrfApplicant $mrfApplicant)
    {
        return view('mrf_applicant.edit', compact('mrfApplicant'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, MrfApplicant $mrfApplicant)
    {
        $request->validate([
            'requisition_id' => 'required|exists:requisitions,id',
            'employee_id' => 'required|exists:employees,id',
            'status' => 'required|string',
        ]);

        $mrfApplicant->update($request->all());

        return redirect()->route('mrf_applicant.index')->with('success', 'Applicant updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $mrfApplicant = MrfApplicant::find($id);

        $mrfApplicant->delete();

        return redirect()->back()->with('success', 'Applicant deleted successfully.');
    }
    public function updateStatus(Request $request, Requisition $requisition)
    {
        // Validate the status input to ensure it is a valid status
        $request->validate([
            'status' => 'required|string|in:Open,Approved,For Approval,Meet & Greet / Intro,Process Requirement,Agency Orientation,Client Orientation,Deploy,Disapproved,Cancel',
        ]);
        $action = MrfAction::create([
            'mrf_id' => $requisition->id,
            'user_id' => auth()->id(),
            'action' => $request->status,
        ]);
        // Update the status of the requisition
        $requisition->status = $request->status;
        $requisition->save();





        return redirect()->back()->with('success', 'Requisition status updated successfully.');
    }
}
