<?php

namespace App\Http\Controllers;

use App\Models\Mortuary;
use App\Models\Employee;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class MortuaryController extends Controller
{

    public function index(Request $request)
    {
        $employee = Employee::leftJoin('mortuary_table', 'employees.id', '=', 'mortuary_table.employee_id')
            ->whereNull('mortuary_table.employee_id') // Filter employees who do not have a mortuary record
            ->select('employees.*')
            ->get();

        $mortuaries = Mortuary::all();
        if ($request->ajax()) {
            $data = Mortuary::with('employee')->get();

            return DataTables::of($data)


                // Allow HTML for these columns
                ->make(true);
        }

        return view('Admin.Payroll.deduction.mortuary', compact('employee'));
    }

    public function updateStatus(Request $request, $id)
    {
        $mortuary = Mortuary::findOrFail($id);

        // Update the mortuary status
        $mortuary->mortuary = $request->input('mortuary');
        $mortuary->save();

        return response()->json([
            'status' => 'success',
            'message' => 'Mortuary status updated successfully.'
        ]);
    }
    public function updateStatusloan(Request $request, $id)
    {
        $loan = Mortuary::findOrFail($id);

        // Update the mortuary status
        $loan->loan = $request->input('loan');
        $loan->save();

        return response()->json([
            'status' => 'success',
            'message' => 'loan status updated successfully.'
        ]);
    }

    public function create()
    {
        return view('mortuaries.create');
    }

    public function store(Request $request)
    {
        // Validate the incoming request data
        $request->validate([
            'employee_id' => 'required|exists:employees,id',  // Validate if employee exists
            'mortuary' => 'nullable|string',
            'loan' => 'nullable|string',
            'rate' => 'nullable|string',
        ]);

        // Check if the employee already has an existing mortuary record
        $existingMortuary = Mortuary::where('employee_id', $request->employee_id)->first();

        // If a mortuary record already exists for this employee, prevent saving and show a message
        if ($existingMortuary) {
            return redirect()->route('mortuaries.index')->with('error', 'This employee already has a mortuary record.');
        }

        // If no existing record found, create a new mortuary record
        Mortuary::create($request->all());

        // Redirect back with success message
        return redirect()->route('mortuaries.index')->with('success', 'Mortuary record created successfully.');
    }


    public function show(Mortuary $mortuary)
    {
        return view('mortuaries.show', compact('mortuary'));
    }

    public function edit(Mortuary $mortuary)
    {
        return view('mortuaries.edit', compact('mortuary'));
    }

    public function update(Request $request, Mortuary $mortuary)
    {
        $request->validate([
            'employee_id' => 'required|exists:employees,id',
            'mortuary' => 'nullable|string',
            'rate' => 'nullable|string',
        ]);

        $mortuary->update($request->all());
        return redirect()->route('mortuaries.index')->with('success', 'Mortuary record updated successfully.');
    }

    public function destroy(Mortuary $mortuary)
    {
        $mortuary->delete();
        return redirect()->route('mortuaries.index')->with('success', 'Mortuary record deleted successfully.');
    }
}
